/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidInteractive;
import cofh.core.util.helpers.DamageHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.entity.monster.EntityBlizz;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockFluidCryotheum
extends BlockFluidInteractive {
    public static final int LEVELS = 5;
    public static final Material materialFluidCryotheum = new MaterialLiquid(MapColor.field_151657_g);
    private static boolean effect = true;
    private static boolean enableSourceFall = true;

    public BlockFluidCryotheum(Fluid fluid) {
        super(fluid, materialFluidCryotheum, "thermalfoundation", "cryotheum");
        this.setQuantaPerBlock(5);
        this.setTickRate(15);
        this.func_149711_c(1000.0f);
        this.func_149713_g(1);
        this.setParticleColor(0.15f, 0.7f, 1.0f);
    }

    public static void config() {
        String category = "Fluid.Cryotheum";
        String comment = "If TRUE, Fluid Cryotheum will be worse than lava, except cold.";
        effect = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Effect", category, effect, comment);
        comment = "If TRUE, Fluid Cryotheum Source blocks will gradually fall downwards.";
        enableSourceFall = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Fall", category, enableSourceFall, comment);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        entity.func_70066_B();
        if (!effect) {
            return;
        }
        if (entity.field_70181_x < -0.25 || entity.field_70181_x > 0.25) {
            entity.field_70181_x *= 0.25;
        }
        if (entity.field_70179_y < -0.25 || entity.field_70179_y > 0.25) {
            entity.field_70179_y *= 0.25;
        }
        if (entity.field_70159_w < -0.25 || entity.field_70159_w > 0.25) {
            entity.field_70159_w *= 0.25;
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        if (world.func_82737_E() % 8L != 0L) {
            return;
        }
        if (entity instanceof EntityZombie || entity instanceof EntityCreeper) {
            EntitySnowman snowman = new EntitySnowman(world);
            snowman.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            world.func_72838_d((Entity)snowman);
            entity.func_70106_y();
        } else if (entity instanceof EntityBlizz || entity instanceof EntitySnowman) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76424_c, 120, 0));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76428_l, 120, 0));
        } else if (entity instanceof EntityBlaze) {
            entity.func_70097_a((DamageSource)DamageHelper.CRYOTHEUM, 10.0f);
        } else {
            boolean t = entity.field_70133_I;
            entity.func_70097_a((DamageSource)DamageHelper.CRYOTHEUM, 2.0f);
            entity.field_70133_I = t;
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return TFFluids.fluidCryotheum.getLuminosity();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (effect) {
            this.checkForInteraction(world, pos);
        }
        if (enableSourceFall && this.func_176201_c(state) == 0) {
            BlockPos offsetPos = pos.func_177982_a(0, this.densityDir, 0);
            IBlockState offsetState = world.func_180495_p(offsetPos);
            int bMeta = offsetState.func_177230_c().func_176201_c(offsetState);
            if (offsetState.func_177230_c() == this && bMeta != 0) {
                world.func_180501_a(offsetPos, this.func_176223_P(), 3);
                world.func_175698_g(pos);
                return;
            }
        }
        super.func_180650_b(world, pos, state, rand);
    }

    protected void interactWithBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c() == this) {
            return;
        }
        if (this.hasInteraction(state)) {
            world.func_180501_a(pos, this.getInteraction(state), 3);
        } else if (state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && world.func_175623_d(pos.func_177972_a(EnumFacing.UP))) {
            world.func_180501_a(pos.func_177972_a(EnumFacing.UP), Blocks.field_150431_aC.func_176223_P(), 3);
        }
    }

    public void addInteractions() {
        this.addInteraction((Block)Blocks.field_150349_c, Blocks.field_150346_d);
        this.addInteraction(Blocks.field_150355_j.func_176223_P(), Blocks.field_150432_aD);
        this.addInteraction((Block)Blocks.field_150355_j, Blocks.field_150433_aE);
        this.addInteraction(Blocks.field_150358_i.func_176223_P(), Blocks.field_150432_aD);
        this.addInteraction((Block)Blocks.field_150358_i, Blocks.field_150433_aE);
        this.addInteraction(Blocks.field_150353_l.func_176223_P(), Blocks.field_150343_Z);
        this.addInteraction((Block)Blocks.field_150353_l, Blocks.field_150348_b);
        this.addInteraction((Block)Blocks.field_150362_t, Blocks.field_150350_a);
        this.addInteraction((Block)Blocks.field_150361_u, Blocks.field_150350_a);
        this.addInteraction((Block)Blocks.field_150329_H, Blocks.field_150350_a);
        this.addInteraction((Block)Blocks.field_150480_ab, Blocks.field_150350_a);
        this.addInteraction(TFFluids.blockFluidGlowstone.func_176223_P(), Blocks.field_150426_aN);
    }

    public boolean initialize() {
        this.setRegistryName("fluid_cryotheum");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlock itemBlock = new ItemBlock((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        BlockFluidCryotheum.config();
        this.addInteractions();
        return true;
    }
}

