/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item;

import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalfoundation.ThermalFoundation;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Loader;

public class ItemFertilizer
extends ItemMulti
implements IInitializer {
    public static ItemStack fertilizerBasic;
    public static ItemStack fertilizerRich;
    public static ItemStack fertilizerFlux;

    public ItemFertilizer() {
        super("thermalfoundation");
        this.func_77655_b("fertilizer");
        this.func_77637_a(ThermalFoundation.tabUtils);
    }

    private boolean growBlock(World world, BlockPos pos, IBlockState state) {
        IGrowable growable;
        if (state.func_177230_c() instanceof IGrowable && (growable = (IGrowable)state.func_177230_c()).func_176473_a(world, pos, state, world.field_72995_K)) {
            if (ServerHelper.isServerWorld((World)world) && growable.func_180670_a(world, world.field_73012_v, pos, state)) {
                growable.func_176474_b(world, world.field_73012_v, pos, state);
                world.func_175718_b(2005, pos, 0);
            }
            return true;
        }
        return false;
    }

    private boolean onApplyBonemeal(ItemStack stack, World world, BlockPos pos, EntityPlayer player, EnumHand hand, int radius) {
        IBlockState state = world.func_180495_p(pos);
        int hook = ForgeEventFactory.onApplyBonemeal((EntityPlayer)player, (World)world, (BlockPos)pos, (IBlockState)state, (ItemStack)stack, (EnumHand)hand);
        if (hook != 0) {
            return hook > 0;
        }
        boolean used = false;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int i = x - radius; i <= x + radius; ++i) {
            for (int k = z - radius; k <= z + radius; ++k) {
                BlockPos pos2 = new BlockPos(i, y, k);
                used |= this.growBlock(world, pos2, world.func_180495_p(pos2));
            }
        }
        if (used) {
            stack.func_190918_g(1);
        }
        return used;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.PASS;
        }
        int radius = 1 + ItemHelper.getItemDamage((ItemStack)stack);
        if (this.onApplyBonemeal(stack, world, pos, player, hand, radius)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean initialize() {
        fertilizerBasic = this.addItem(0, "fertilizerBasic");
        fertilizerRich = this.addItem(1, "fertilizerRich");
        fertilizerFlux = this.addItem(2, "fertilizerFlux", EnumRarity.UNCOMMON);
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean register() {
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)fertilizerBasic, (int)4), (Object[])new Object[]{"dustWood", "dustWood", "dustSaltpeter", "crystalSlag"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)fertilizerBasic, (int)16), (Object[])new Object[]{"dustCharcoal", "dustSaltpeter", "crystalSlag"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)fertilizerRich, (int)4), (Object[])new Object[]{"dustWood", "dustWood", "dustSaltpeter", "crystalSlagRich"});
        RecipeHelper.addShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)fertilizerRich, (int)16), (Object[])new Object[]{"dustCharcoal", "dustSaltpeter", "crystalSlagRich"});
        if (!Loader.isModLoaded((String)"thermalexpansion")) {
            RecipeHelper.addShapelessRecipe((ItemStack)fertilizerRich, (Object[])new Object[]{fertilizerBasic, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b())});
            RecipeHelper.addShapelessOreRecipe((ItemStack)fertilizerFlux, (Object[])new Object[]{fertilizerRich, "dustRedstone"});
        }
        return true;
    }
}

