/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.plugins;

import cofh.core.util.ModPlugin;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.ThermalFoundation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.EnumRarity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class PluginTConstruct
extends ModPlugin {
    public static final String MOD_ID = "tconstruct";
    public static final String MOD_NAME = "Tinkers' Construct";

    public PluginTConstruct() {
        super(MOD_ID, MOD_NAME);
    }

    public boolean initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Tinkers' Construct is enabled.";
        boolean bl = this.enable = Loader.isModLoaded((String)MOD_ID) && ThermalFoundation.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!this.enable) {
            return false;
        }
        try {
            PluginTConstruct.addFluid("platinum", 9031400, 1400, EnumRarity.UNCOMMON);
            PluginTConstruct.addFluid("iridium", 13422051, 1400, EnumRarity.UNCOMMON);
            PluginTConstruct.addFluid("invar", 0x949D99, 1400);
            PluginTConstruct.addFluid("constantan", 13476447, 650);
            PluginTConstruct.addFluid("signalum", 13195298, 1000, EnumRarity.UNCOMMON);
            PluginTConstruct.addFluid("lumium", 15394206, 1000, EnumRarity.UNCOMMON);
            PluginTConstruct.addFluid("enderium", 2782581, 1600, EnumRarity.RARE);
            ArrayList<FluidStack> alloyList = new ArrayList<FluidStack>();
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"invar"), 144));
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"iron"), 96));
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"nickel"), 48));
            PluginTConstruct.addAlloy(alloyList);
            alloyList.clear();
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"constantan"), 144));
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"copper"), 72));
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"nickel"), 72));
            PluginTConstruct.addAlloy(alloyList);
            alloyList.clear();
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"signalum"), 144));
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"copper"), 108));
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"silver"), 36));
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"redstone"), 250));
            PluginTConstruct.addAlloy(alloyList);
            alloyList.clear();
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"lumium"), 144));
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"tin"), 108));
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"silver"), 36));
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"glowstone"), 250));
            PluginTConstruct.addAlloy(alloyList);
            alloyList.clear();
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"enderium"), 144));
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"lead"), 108));
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"platinum"), 36));
            alloyList.add(new FluidStack(FluidRegistry.getFluid((String)"ender"), 250));
            PluginTConstruct.addAlloy(alloyList);
            alloyList.clear();
        }
        catch (Throwable t) {
            ThermalFoundation.LOG.error("Thermal Foundation: Tinkers' Construct Plugin encountered an error:", t);
            this.error = true;
        }
        return !this.error;
    }

    public boolean register() {
        if (!this.enable) {
            return false;
        }
        if (!this.error) {
            ThermalFoundation.LOG.info("Thermal Foundation: Tinkers' Construct Plugin Enabled.");
        }
        return !this.error;
    }

    private static void addFluid(String fluidName, int color, int temperature, EnumRarity rarity) {
        Fluid fluid = new FluidMolten(fluidName).setColor(color).setTemperature(temperature).setRarity(rarity);
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        NBTTagCompound message = new NBTTagCompound();
        message.func_74778_a("fluid", fluid.getName());
        message.func_74778_a("ore", StringHelper.titleCase((String)fluidName));
        message.func_74757_a("toolforge", true);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"integrateSmeltery", (NBTTagCompound)message);
    }

    private static void addFluid(String fluidName, int color, int temperature) {
        PluginTConstruct.addFluid(fluidName, color, temperature, EnumRarity.COMMON);
    }

    private static void addAlloy(List<FluidStack> fluidStacks) {
        NBTTagList tagList = new NBTTagList();
        for (FluidStack stack : fluidStacks) {
            tagList.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        NBTTagCompound message = new NBTTagCompound();
        message.func_74782_a("alloy", (NBTBase)tagList);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"alloy", (NBTTagCompound)message);
    }

    public static class FluidMolten
    extends Fluid {
        public int color = 0xFFFFFF;

        public FluidMolten(String fluidName) {
            super(fluidName, new ResourceLocation("tconstruct:blocks/fluids/molten_metal"), new ResourceLocation("tconstruct:blocks/fluids/molten_metal_flow"));
        }

        public FluidMolten setColor(int color) {
            this.color = 0xFF000000 | color;
            return this;
        }

        public int getColor() {
            return this.color;
        }
    }
}

