/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.event;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockGroup;
import crafttweaker.api.world.IDimension;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="crafttweaker.event.PlayerBonemealEvent")
@ZenRegister
public class PlayerBonemealEvent {
    private final IPlayer player;
    private final IBlockGroup blocks;
    private final int x;
    private final int y;
    private final int z;
    private boolean canceled;
    private boolean processed;

    public PlayerBonemealEvent(IPlayer player, IBlockGroup blocks, int x, int y, int z) {
        this.player = player;
        this.blocks = blocks;
        this.x = x;
        this.y = y;
        this.z = z;
        this.canceled = false;
        this.processed = false;
    }

    @ZenMethod
    public void cancel() {
        this.canceled = true;
    }

    @ZenMethod
    public void process() {
        this.processed = true;
    }

    @ZenGetter(value="canceled")
    public boolean isCanceled() {
        return this.canceled;
    }

    @ZenGetter(value="processed")
    public boolean isProcessed() {
        return this.processed;
    }

    @ZenGetter(value="player")
    public IPlayer getPlayer() {
        return this.player;
    }

    @ZenGetter(value="blocks")
    public IBlockGroup getBlocks() {
        return this.blocks;
    }

    @ZenGetter(value="x")
    public int getX() {
        return this.x;
    }

    @ZenGetter(value="y")
    public int getY() {
        return this.y;
    }

    @ZenGetter(value="z")
    public int getZ() {
        return this.z;
    }

    @ZenGetter(value="block")
    public IBlock getBlock() {
        return this.blocks.getBlock(this.x, this.y, this.z);
    }

    @ZenGetter(value="dimension")
    public IDimension getDimension() {
        return this.blocks.getDimension();
    }
}

