/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.event;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockGroup;
import crafttweaker.api.world.IDimension;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenClass(value="crafttweaker.event.PlayerFillBucketEvent")
@ZenRegister
public class PlayerFillBucketEvent {
    private final IPlayer player;
    private final IBlockGroup blocks;
    private final int x;
    private final int y;
    private final int z;
    private boolean canceled;
    private IItemStack result;

    public PlayerFillBucketEvent(IPlayer player, IBlockGroup blocks, int x, int y, int z) {
        this.player = player;
        this.blocks = blocks;
        this.x = x;
        this.y = y;
        this.z = z;
        this.canceled = false;
        this.result = null;
    }

    @ZenMethod
    public void cancel() {
        this.canceled = true;
    }

    @ZenGetter(value="canceled")
    public boolean isCanceled() {
        return this.canceled;
    }

    @ZenGetter(value="result")
    public IItemStack getResult() {
        return this.result;
    }

    @ZenSetter(value="result")
    public void setResult(IItemStack result) {
        this.result = result;
    }

    @ZenGetter(value="player")
    public IPlayer getPlayer() {
        return this.player;
    }

    @ZenGetter(value="blocks")
    public IBlockGroup getBlocks() {
        return this.blocks;
    }

    @ZenGetter(value="x")
    public int getX() {
        return this.x;
    }

    @ZenGetter(value="y")
    public int getY() {
        return this.y;
    }

    @ZenGetter(value="z")
    public int getZ() {
        return this.z;
    }

    @ZenGetter(value="block")
    public IBlock getBlock() {
        return this.blocks.getBlock(this.x, this.y, this.z);
    }

    @ZenGetter(value="dimension")
    public IDimension getDimension() {
        return this.blocks.getDimension();
    }
}

