/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.item;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemCondition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IItemTransformer;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.player.IPlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IngredientStack
implements IIngredient {
    private final IIngredient ingredient;
    private final int amount;

    public IngredientStack(IIngredient ingredient, int amount) {
        this.ingredient = ingredient;
        this.amount = amount;
    }

    @Override
    public String getMark() {
        return null;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public List<IItemStack> getItems() {
        return this.ingredient.getItems();
    }

    @Override
    public IItemStack[] getItemArray() {
        return this.ingredient.getItemArray();
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        return Collections.emptyList();
    }

    @Override
    public IIngredient amount(int amount) {
        return new IngredientStack(this.ingredient, amount);
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientStack(this.ingredient.transform(transformer), this.amount);
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientStack(this.ingredient.only(condition), this.amount);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientStack(this.ingredient.marked(mark), this.amount);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public boolean matches(IItemStack item) {
        return item.getAmount() == this.amount && this.ingredient.matches(item);
    }

    @Override
    public boolean matchesExact(IItemStack item) {
        return item.getAmount() == this.amount && this.ingredient.matchesExact(item);
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        return false;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        return this.ingredient.contains(ingredient);
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        return this.ingredient.applyTransform(item, byPlayer);
    }

    @Override
    public Object getInternal() {
        return null;
    }

    @Override
    public boolean hasTransformers() {
        return this.ingredient.hasTransformers();
    }

    public String toString() {
        String s = "(Ingredients) ";
        ArrayList<String> names = new ArrayList<String>();
        for (IItemStack st : this.ingredient.getItems()) {
            names.add(st.getName());
        }
        s = s + String.join((CharSequence)",", names);
        return s;
    }
}

