/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.item;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenExpansion(value="crafttweaker.item.IIngredient")
@ZenRegister
public class IngredientTransform {
    @ZenMethod
    public static IIngredient transformDamage(IIngredient ingredient) {
        return IngredientTransform.transformDamage(ingredient, 1);
    }

    @ZenMethod
    public static IIngredient transformDamage(IIngredient ingredient, int damage) {
        return ingredient.transform((item, byPlayer) -> {
            int newDamage = item.getDamage() + damage;
            if (newDamage > item.getMaxDamage()) {
                return item;
            }
            byPlayer.give(item.withDamage(newDamage));
            return item;
        });
    }

    @ZenMethod
    public static IIngredient transformReplace(IIngredient ingredient, IItemStack withItem) {
        return ingredient.transform((item, byPlayer) -> {
            if (item.getAmount() > 1) {
                byPlayer.give(withItem);
                return item;
            }
            byPlayer.give(withItem.withAmount(withItem.getAmount()));
            return item;
        });
    }

    @ZenMethod
    public static IIngredient transformConsume(IIngredient ingredient, int amount) {
        return ingredient.transform((item, byPlayer) -> {
            byPlayer.give(item.withAmount(Math.max(item.getAmount() - amount, 0)));
            return item;
        });
    }

    @ZenMethod
    public static IIngredient noReturn(IIngredient ingredient) {
        return ingredient.transform((item, byPlayer) -> null);
    }

    @ZenMethod
    public static IIngredient giveBack(IIngredient ingredient, @Optional IItemStack givenItem) {
        return ingredient.transform((item, byPlayer) -> {
            if (givenItem == null) {
                byPlayer.give(item.withAmount(1));
                return item;
            }
            byPlayer.give(givenItem);
            return item;
        });
    }
}

