/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.commands;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.CrafttweakerImplementationAPI;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.mods.IMod;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.api.potions.IPotion;
import crafttweaker.api.recipes.ICraftingRecipe;
import crafttweaker.api.recipes.IFurnaceRecipe;
import crafttweaker.api.recipes.ShapedRecipe;
import crafttweaker.api.recipes.ShapelessRecipe;
import crafttweaker.api.world.IBiome;
import crafttweaker.mc1120.brackets.BracketHandlerPotion;
import crafttweaker.mc1120.commands.CTChatCommand;
import crafttweaker.mc1120.commands.ClipboardHelper;
import crafttweaker.mc1120.commands.CommandUtils;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.NBTUtils;
import crafttweaker.mc1120.commands.NamesCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import crafttweaker.mc1120.commands.dumpZScommand.DumpZsCommand;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.player.MCPlayer;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Commands {
    public static final PotionComparator POTION_COMPARATOR = new PotionComparator();
    public static final Comparator<Item> ITEM_COMPARATOR = new ItemComparator();

    static void registerCommands() {
        CTChatCommand.registerCommand(new CraftTweakerCommand("help"){

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                CTChatCommand.sendUsage(sender);
            }

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct help", "/ct help", true), SpecialMessagesChat.getNormalMessage(" \u00a73Prints out the this help page"));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("liquids"){

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                List<ILiquidDefinition> liquids = CraftTweakerAPI.game.getLiquids();
                liquids.sort(CrafttweakerImplementationAPI.LIQUID_COMPARATOR);
                CraftTweakerAPI.logCommand("Liquids:");
                for (ILiquidDefinition liquid : liquids) {
                    CraftTweakerAPI.logCommand("<liquid:" + liquid.getName() + ">, " + liquid.getDisplayName());
                }
                sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("List of liquids generated;", sender));
            }

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct liquids", "/ct liquids", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs a list of all liquid names in the game to the crafttweaker.log"));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("blocks"){

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                List<IBlockDefinition> blocks = CraftTweakerAPI.game.getBlocks();
                blocks.sort(CrafttweakerImplementationAPI.BLOCK_COMPARATOR);
                CraftTweakerAPI.logCommand("Blocks:");
                for (IBlockDefinition block : blocks) {
                    CraftTweakerAPI.logCommand("<block:" + block.getId() + ">, " + block.getDisplayName());
                }
                sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("List of blocks generated", sender));
            }

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct blocks", "/ct blocks", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs a list of all blocks in the game to the crafttweaker log"));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("entities"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct entities", "/ct entities", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs a list of all entity definitions in the game to the crafttweaker log"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                List<IEntityDefinition> entities = CraftTweakerAPI.game.getEntities();
                entities.sort(CrafttweakerImplementationAPI.ENTITY_COMPARATOR);
                CraftTweakerAPI.logCommand("Entities:");
                for (IEntityDefinition entity : entities) {
                    CraftTweakerAPI.logCommand(entity.getId() + " -- " + entity.getName());
                }
                sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("List of Entities generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("potions"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct potions", "/ct potions", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs a list of all potions to the crafttweaker.log"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                List<IPotion> potions = CraftTweakerAPI.game.getPotions();
                potions.sort(POTION_COMPARATOR);
                CraftTweakerAPI.logCommand("Potions:");
                BracketHandlerPotion.getPotionNames().forEach((k, v) -> {
                    int id = Potion.field_188414_b.func_148757_b(v);
                    CraftTweakerAPI.logCommand(k + " -- color: " + v.func_76401_j() + (v.func_76398_f() ? " -- is bad effect" : " -- is good effect") + " -- PotionID: " + id);
                });
                sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("List of Potions generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("recipeNames"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct recipeNames", "/ct recipeNames", true), SpecialMessagesChat.getNormalMessage(" \u00a73A modid can be provided to filter results"), SpecialMessagesChat.getNormalMessage(" \u00a73/ct recipeNames <modid>"), SpecialMessagesChat.getNormalMessage(" \u00a73Lists all crafting recipe names in the game"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                CraftTweakerAPI.logCommand("Recipe names:");
                String filter = args.length == 0 ? "" : args[0];
                for (Map.Entry entry : ForgeRegistries.RECIPES.getEntries()) {
                    if (!filter.isEmpty() && !((ResourceLocation)entry.getKey()).func_110624_b().equalsIgnoreCase(filter)) continue;
                    CraftTweakerAPI.logCommand(((ResourceLocation)entry.getKey()).toString() + " - " + ((IRecipe)entry.getValue()).func_77571_b());
                }
                sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("Recipe list generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("recipes"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct recipes", "/ct recipes", true), SpecialMessagesChat.getNormalMessage(" \u00a73Lists all crafting recipes in the game"), SpecialMessagesChat.getClickableCommandText(" \u00a7a/ct recipes hand", "/ct recipes hand", true), SpecialMessagesChat.getNormalMessage("  \u00a7bLists all crafting recipes for the item in your hand"), SpecialMessagesChat.getNormalMessage("  \u00a7bAlso copies the recipes to clipboard"), SpecialMessagesChat.getClickableCommandText(" \u00a7a/ct recipes furnace", "/ct recipes furnace", true), SpecialMessagesChat.getNormalMessage("  \u00a7blists all furnace recipes in the game"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (args.length == 0) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Generating recipe list, this could take a while..."));
                    CraftTweakerAPI.logCommand("Recipes:");
                    for (ICraftingRecipe recipe : CraftTweakerAPI.recipes.getAll()) {
                        try {
                            CraftTweakerAPI.logCommand(recipe.toCommandString());
                        }
                        catch (Throwable ex) {
                            IItemStack out;
                            if (recipe instanceof ShapedRecipe) {
                                ShapedRecipe shaped = (ShapedRecipe)recipe;
                                out = shaped.getOutput();
                                CraftTweakerAPI.logError("Could not dump recipe for " + out, ex);
                                continue;
                            }
                            if (recipe instanceof ShapelessRecipe) {
                                ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
                                out = shapeless.getOutput();
                                CraftTweakerAPI.logError("Could not dump recipe for " + out, ex);
                                continue;
                            }
                            CraftTweakerAPI.logError("Could not dump recipe", ex);
                        }
                    }
                    sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("Recipe list generated", sender));
                } else if (args[0].equals("hand") && sender.func_174793_f() instanceof EntityPlayer) {
                    MCPlayer player = new MCPlayer((EntityPlayer)sender.func_174793_f());
                    IItemStack item = player.getCurrentItem();
                    if (item != null) {
                        List<ICraftingRecipe> recipes = CraftTweakerAPI.recipes.getRecipesFor(item.anyAmount());
                        if (recipes.isEmpty()) {
                            player.sendChat("No crafting recipes found for that item");
                        } else {
                            StringBuilder recipesString = new StringBuilder();
                            for (ICraftingRecipe recipe : recipes) {
                                CraftTweakerAPI.logCommand(recipe.toCommandString());
                                player.sendChat(recipe.toCommandString());
                                recipesString.append(recipe.toCommandString()).append("\n");
                            }
                            player.copyToClipboard(recipesString.toString());
                        }
                    } else {
                        player.sendChat("No item was found");
                    }
                } else if (args[0].equals("furnace")) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Generating furnace list, this could take a while..."));
                    CraftTweakerAPI.logCommand("Furnace Recipes:");
                    for (IFurnaceRecipe recipe : CraftTweakerAPI.furnace.getAll()) {
                        try {
                            CraftTweakerAPI.logCommand(recipe.toCommandString());
                        }
                        catch (Throwable ex) {
                            CraftTweakerAPI.logError("Could not dump furnace recipe", ex);
                        }
                    }
                    sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("Furnace Recipe list generated", sender));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Invalid arguments for recipes command"));
                }
            }

            @Override
            public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
                String[] subCommands = new String[]{"hand", "furnace"};
                ArrayList<String> currentPossibleCommands = new ArrayList<String>();
                for (String cmd : subCommands) {
                    System.out.println("Trying " + cmd);
                    if (!cmd.startsWith(args[0])) continue;
                    currentPossibleCommands.add(cmd);
                }
                return currentPossibleCommands;
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("inventory"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct inventory", "/ct inventory", true), SpecialMessagesChat.getNormalMessage(" \u00a73Lists all items in your inventory"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                Entity entity = sender.func_174793_f();
                if (entity instanceof EntityPlayer) {
                    MCPlayer player = new MCPlayer((EntityPlayer)entity);
                    for (int i = 0; i < player.getInventorySize(); ++i) {
                        IItemStack stack = player.getInventoryStack(i);
                        if (stack == null) continue;
                        CraftTweakerAPI.logCommand(stack.toString());
                    }
                    sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("Recipe list generated", sender));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("This command can only be used as a Player (inGame)"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("hand"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct hand", "/ct hand", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs the name of the item in your hand"), SpecialMessagesChat.getNormalMessage(" \u00a73Also copies the name to clipboard and prints"), SpecialMessagesChat.getNormalMessage(" \u00a73OreDict entries"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                block14: {
                    if (sender.func_174793_f() instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)sender.func_174793_f();
                        ItemStack heldItem = player.func_184614_ca();
                        if (!heldItem.func_190926_b()) {
                            Object nbt;
                            List<String> oreDictNames = CommandUtils.getOreDictOfItem(heldItem);
                            int meta = heldItem.func_77960_j();
                            String itemName = "<" + heldItem.func_77973_b().getRegistryName() + (meta == 0 ? "" : ":" + meta) + ">";
                            String withNBT = "";
                            if (heldItem.serializeNBT().func_74764_b("tag") && ((String)(nbt = NBTConverter.from(heldItem.serializeNBT().func_74781_a("tag"), false).toString())).length() > 0) {
                                withNBT = ".withTag(" + (String)nbt + ")";
                            }
                            ClipboardHelper.copyStringPlayer(player, itemName + withNBT);
                            ClipboardHelper.sendMessageWithCopy(player, "Item \u00a72" + itemName + "\u00a7a" + withNBT, itemName + withNBT);
                            if (oreDictNames.size() > 0) {
                                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a73OreDict Entries:"));
                                for (String oreName : oreDictNames) {
                                    ClipboardHelper.sendMessageWithCopy(player, "    \u00a7e- \u00a7b" + oreName, "<ore:" + oreName + ">");
                                }
                            } else {
                                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a73No OreDict Entries"));
                            }
                        } else {
                            RayTraceResult rayTraceResult = CommandUtils.getPlayerLookat(player, 100.0);
                            if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                                BlockPos blockPos = rayTraceResult.func_178782_a();
                                IBlockState block = server.func_130014_f_().func_180495_p(blockPos);
                                int meta = block.func_177230_c().func_176201_c(block);
                                String blockName = "<" + block.func_177230_c().getRegistryName() + (meta == 0 ? "" : ":" + meta) + ">";
                                ClipboardHelper.copyStringPlayer(player, blockName);
                                ClipboardHelper.sendMessageWithCopy(player, "Block \u00a72" + blockName + " \u00a7rat \u00a79[" + blockPos.func_177958_n() + ", " + blockPos.func_177956_o() + ", " + blockPos.func_177952_p() + "]\u00a7r", blockName);
                                try {
                                    List<String> oreDictNames = CommandUtils.getOreDictOfItem(new ItemStack(block.func_177230_c(), 1, block.func_177230_c().func_176201_c(block)));
                                    if (oreDictNames.size() > 0) {
                                        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a73OreDict Entries:"));
                                        for (String oreName : oreDictNames) {
                                            ClipboardHelper.sendMessageWithCopy(player, "    \u00a7e- \u00a7b" + oreName, "<ore:" + oreName + ">");
                                        }
                                        break block14;
                                    }
                                    sender.func_145747_a((ITextComponent)new TextComponentString("\u00a73No OreDict Entries"));
                                }
                                catch (IllegalArgumentException e) {
                                    sender.func_145747_a((ITextComponent)new TextComponentString("\u00a73No OreDict Entries"));
                                }
                            } else {
                                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a74Please hold an Item in your hand or look at a Block."));
                            }
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("This command can only be casted by a player inGame"));
                    }
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("mods"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct mods", "/ct mods", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs all active mod IDs and versions in the game"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                CraftTweakerAPI.logCommand("Mods list:");
                for (IMod mod : CraftTweakerAPI.loadedMods) {
                    String message = "\u00a75" + mod.getId() + "\u00a7r - \u00a7d" + mod.getName() + "\u00a7 - " + mod.getVersion();
                    String messageWithoutColor = mod.getId() + " - " + mod.getName() + " - " + mod.getVersion();
                    sender.func_145747_a((ITextComponent)new TextComponentString(message));
                    CraftTweakerAPI.logCommand(messageWithoutColor);
                }
                sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("List of Mods generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("oredict"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct oredict", "/ct oredict", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs all ore dictionary entries in the game to the crafttweaker log"), SpecialMessagesChat.getClickableCommandText("\u00a7a/ct oredict <name>", "/ct oredict ", false), SpecialMessagesChat.getNormalMessage("  \u00a7bOutputs all items in the given ore dictionary entry to the crafttweaker log"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (args.length > 0) {
                    String entryName = args[0];
                    IOreDictEntry entry = CraftTweakerAPI.oreDict.get(entryName);
                    if (entry.isEmpty()) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Entry doesn't exist"));
                        return;
                    }
                    CraftTweakerAPI.logCommand("Ore entries for " + entryName + ":");
                    for (IItemStack ore : entry.getItems()) {
                        CraftTweakerAPI.logCommand("-" + ore);
                    }
                } else {
                    for (IOreDictEntry entry : CraftTweakerAPI.oreDict.getEntries()) {
                        if (entry.isEmpty()) continue;
                        CraftTweakerAPI.logCommand("Ore entries for <ore:" + entry.getName() + "> :");
                        for (IItemStack ore : entry.getItems()) {
                            CraftTweakerAPI.logCommand("-" + ore);
                        }
                    }
                }
                sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("OreDict list generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("seeds"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct seeds", "/ct seeds", true), SpecialMessagesChat.getNormalMessage(" \u00a73Prints all seeds registered"), SpecialMessagesChat.getNormalMessage(" \u00a73for tall grass"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                CraftTweakerAPI.logCommand("Seeds:");
                for (WeightedItemStack seed : CraftTweakerAPI.vanilla.getSeeds().getSeeds()) {
                    String itemname = "<" + seed.getStack().getName() + ":" + seed.getStack().getDamage() + ">";
                    String message = "\u00a72" + itemname + "\u00a7r - \u00a7e" + (int)seed.getChance();
                    sender.func_145747_a(SpecialMessagesChat.getCopyMessage(message, itemname));
                    CraftTweakerAPI.logCommand("Seed: " + message);
                }
                sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("Seed list generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("wiki"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct wiki", "/ct wiki", true), SpecialMessagesChat.getNormalMessage(" \u00a73Opens your browser with the wiki"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.func_174793_f() instanceof EntityPlayer) {
                    MCPlayer player = new MCPlayer((EntityPlayer)sender.func_174793_f());
                    player.openBrowser("http://minetweaker3.powerofbytes.com/wiki/");
                    sender.func_145747_a(SpecialMessagesChat.getClickableBrowserLinkText("http://minetweaker3.powerofbytes.com/wiki/", "http://minetweaker3.powerofbytes.com/wiki/"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("http://minetweaker3.powerofbytes.com/wiki/"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("bugs"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct bugs", "/ct bugs", true), SpecialMessagesChat.getNormalMessage(" \u00a73Opens your browser with the GitHub bug tracker"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.func_174793_f() instanceof EntityPlayer) {
                    MCPlayer player = new MCPlayer((EntityPlayer)sender.func_174793_f());
                    player.openBrowser("https://github.com/jaredlll08/CraftTweaker/issues");
                    sender.func_145747_a(SpecialMessagesChat.getClickableBrowserLinkText("http://minetweaker3.powerofbytes.com/wiki/", "http://minetweaker3.powerofbytes.com/wiki/"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("https://github.com/jaredlll08/CraftTweaker/issues"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("discord"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct discord", "/ct discord", true), SpecialMessagesChat.getNormalMessage(" \u00a73Opens your browser with a link to the Discord server"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.func_174793_f() instanceof EntityPlayer) {
                    MCPlayer player = new MCPlayer((EntityPlayer)sender.func_174793_f());
                    player.openBrowser("https://discord.gg/3VBK9ar");
                    sender.func_145747_a(SpecialMessagesChat.getClickableBrowserLinkText("https://discord.gg/3VBK9ar", "https://discord.gg/3VBK9ar"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("https://discord.gg/3VBK9ar"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("docs"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct docs", "/ct docs", true), SpecialMessagesChat.getNormalMessage(" \u00a73Opens your browser with the docs"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.func_174793_f() instanceof EntityPlayer) {
                    MCPlayer player = new MCPlayer((EntityPlayer)sender.func_174793_f());
                    player.openBrowser("http://crafttweaker.readthedocs.io/en/latest/");
                    sender.func_145747_a(SpecialMessagesChat.getClickableBrowserLinkText("http://crafttweaker.readthedocs.io/en/latest/", "http://crafttweaker.readthedocs.io/en/latest/"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("http://crafttweaker.readthedocs.io/en/latest/"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("biomes"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct biomes", "/ct biomes", true), SpecialMessagesChat.getNormalMessage(" \u00a73Lists all the biomes in the game"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                CraftTweakerAPI.logCommand("Biomes:");
                for (IBiome biome : CraftTweakerAPI.game.getBiomes()) {
                    CraftTweakerAPI.logCommand("-" + biome.getName());
                }
                sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("Biome list generated", sender));
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("blockinfo"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct blockinfo", "/ct blockinfo", true), SpecialMessagesChat.getNormalMessage(" \u00a73Activates or deactivates block reader. In block info mode,"), SpecialMessagesChat.getNormalMessage(" \u00a73right-click a block to see ID, meta and tile entity data"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.func_174793_f() instanceof EntityPlayer) {
                    MCPlayer player = new MCPlayer((EntityPlayer)sender.func_174793_f());
                    if (CrafttweakerImplementationAPI.blockInfoPlayers.isEmpty()) {
                        CrafttweakerImplementationAPI.blockEventHandler = CrafttweakerImplementationAPI.events.onPlayerInteract(CrafttweakerImplementationAPI.LISTEN_BLOCK_INFO);
                    }
                    if (CrafttweakerImplementationAPI.blockInfoPlayers.contains(player)) {
                        CrafttweakerImplementationAPI.blockInfoPlayers.remove(player);
                        player.sendChat("Block info mode deactivated.");
                    } else {
                        CrafttweakerImplementationAPI.blockInfoPlayers.add(player);
                        player.sendChat("Block info mode activated. Right-click a block to see its data.");
                    }
                    if (CrafttweakerImplementationAPI.blockInfoPlayers.isEmpty()) {
                        CrafttweakerImplementationAPI.blockEventHandler.close();
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("This Command can only be performed from a Player(InGame)"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("copy"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct copy", "/ct copy", false), SpecialMessagesChat.getNormalMessage(" \u00a73Copies the provided string behind it"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                ClipboardHelper.copyCommandRun(sender, args);
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("nbt"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct nbt", "/ct nbt", true), SpecialMessagesChat.getNormalMessage(" \u00a73Shows the NBT of the block you are looking at"), SpecialMessagesChat.getNormalMessage(" \u00a73or the item you are holding"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.func_174793_f() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)sender.func_174793_f();
                    ItemStack heldItem = player.func_184614_ca();
                    if (heldItem != ItemStack.field_190927_a) {
                        String itemName = "<" + heldItem.func_77973_b().getRegistryName() + ":" + heldItem.func_77960_j() + ">";
                        String nbt = "";
                        if (heldItem.serializeNBT().func_74764_b("tag")) {
                            nbt = NBTConverter.from(heldItem.serializeNBT().func_74781_a("tag"), false).toString();
                        }
                        String withNBT = "";
                        if (nbt.length() > 0) {
                            withNBT = ".withTag(" + nbt + ")";
                        }
                        ClipboardHelper.copyStringPlayer(player, itemName + withNBT);
                        ClipboardHelper.sendMessageWithCopy(player, "Item \u00a72" + itemName, itemName + withNBT);
                        if (nbt.length() > 0) {
                            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a73NBT-Data:"));
                            ClipboardHelper.sendMessageWithCopy(player, NBTUtils.getAppealingString(nbt), nbt);
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a73No NBT Data"));
                        }
                    } else {
                        RayTraceResult rayTraceResult = CommandUtils.getPlayerLookat(player, 100.0);
                        if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                            BlockPos blockPos = rayTraceResult.func_178782_a();
                            IBlockState block = server.func_130014_f_().func_180495_p(blockPos);
                            ClipboardHelper.sendMessageWithCopy(player, "Block \u00a72[" + block.func_177230_c().getRegistryName() + ":" + block.func_177230_c().func_176201_c(block) + "] \u00a7rat \u00a79[" + blockPos.func_177958_n() + ", " + blockPos.func_177956_o() + ", " + blockPos.func_177952_p() + "]\u00a7r", block.func_177230_c().getRegistryName() + ":" + block.func_177230_c().func_176201_c(block));
                            TileEntity te = server.func_130014_f_().func_175625_s(blockPos);
                            if (te != null) {
                                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a73NBT-Data:"));
                                String nbt = NBTConverter.from((NBTBase)te.serializeNBT(), false).toString();
                                ClipboardHelper.sendMessageWithCopy(player, NBTUtils.getAppealingString(nbt), nbt);
                            } else {
                                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a73Block is no TileEntity and has no NBT"));
                            }
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a74Please hold an Item in your hand or look at a Block."));
                        }
                    }
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("log"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct log", "/ct log", true), SpecialMessagesChat.getNormalMessage(" \u00a73Sends a clickable link to open the crafttweaker.log"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.func_174793_f() instanceof EntityPlayer) {
                    sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("", sender));
                } else {
                    sender.func_145747_a(SpecialMessagesChat.getNormalMessage("Command must be executed as a Player (inGame)"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("scripts"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct scripts", "/ct scripts", true), SpecialMessagesChat.getNormalMessage(" \u00a73Sends a clickable link to open the scripts directory"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.func_174793_f() instanceof EntityPlayer) {
                    sender.func_145747_a(SpecialMessagesChat.getFileOpenText("Click to open the \u00a7a/scripts/ \u00a7rDirectory [\u00a76Click here to open\u00a7r]", new File("scripts/").getAbsolutePath()));
                } else {
                    sender.func_145747_a(SpecialMessagesChat.getNormalMessage("Path to the scripts: " + new File("scripts/").getAbsolutePath()));
                    sender.func_145747_a(SpecialMessagesChat.getNormalMessage("Command must be executed as a Player (inGame) to be clickable"));
                }
            }
        });
        CTChatCommand.registerCommand(new CraftTweakerCommand("syntax"){

            @Override
            protected void init() {
                this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct syntax", "/ct syntax", true), SpecialMessagesChat.getNormalMessage(" \u00a73Checks the Syntax of the scripts"), SpecialMessagesChat.getNormalMessage(" \u00a73To see the effect you have to restart the game"), SpecialMessagesChat.getNormalMessage(" \u00a73Will print errors of the Bracket Handler"));
            }

            @Override
            public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (args.length > 0 && args[0].equals("debug")) {
                    CraftTweakerAPI.tweaker.enableDebug();
                }
                sender.func_145747_a(SpecialMessagesChat.getNormalMessage("\u00a7bBeginning load of the scripts"));
                boolean loadSuccessful = CraftTweakerAPI.tweaker.loadScript(true, "crafttweaker");
                if (loadSuccessful) {
                    sender.func_145747_a(SpecialMessagesChat.getNormalMessage("Syntax of scripts is \u00a7acorrect\u00a7r, to see the effect \u00a7erestart the game"));
                    sender.func_145747_a(SpecialMessagesChat.getNormalMessage("Please be advised that \u00a7bbrackets (<>) \u00a7rmay have \u00a74errored, see above."));
                    sender.func_145747_a(SpecialMessagesChat.getNormalMessage("If no errors appeared above everything was fine."));
                } else {
                    sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("\u00a74Syntax of the scripts is incorrect!", sender));
                }
            }

            @Override
            public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
                ArrayList<String> commands = new ArrayList<String>(1);
                commands.add("debug");
                return commands;
            }
        });
        CTChatCommand.registerCommand(new DumpZsCommand());
        CTChatCommand.registerCommand(new NamesCommand());
    }

    private static class PotionComparator
    implements Comparator<IPotion>,
    Serializable {
        private PotionComparator() {
        }

        @Override
        public int compare(IPotion o1, IPotion o2) {
            return o1.name().compareTo(o2.name());
        }
    }

    private static class ItemComparator
    implements Comparator<Item>,
    Serializable {
        private ItemComparator() {
        }

        @Override
        public int compare(Item o1, Item o2) {
            return o1.getRegistryName().toString().compareTo(o2.getRegistryName().toString());
        }
    }
}

