/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.furnace;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.recipes.FurnaceRecipe;
import crafttweaker.api.recipes.IFurnaceManager;
import crafttweaker.api.recipes.IFurnaceRecipe;
import crafttweaker.mc1120.actions.ActionAddFurnaceRecipe;
import crafttweaker.mc1120.actions.ActionFurnaceRemoveRecipe;
import crafttweaker.mc1120.actions.ActionSetFuel;
import crafttweaker.mc1120.furnace.SetFuelPattern;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import stanhebben.zenscript.annotations.Optional;

public class MCFurnaceManager
implements IFurnaceManager {
    public static final Map<IItemStack, Integer> fuelMap = new HashMap<IItemStack, Integer>();
    public static List<ActionAddFurnaceRecipe> recipesToAdd = new ArrayList<ActionAddFurnaceRecipe>();
    public static List<ActionFurnaceRemoveRecipe> recipesToRemove = new ArrayList<ActionFurnaceRemoveRecipe>();

    @Override
    public void remove(IIngredient output, @Optional IIngredient input) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null");
        }
        recipesToRemove.add(new ActionFurnaceRemoveRecipe(output, input));
    }

    @Override
    public void removeAll() {
        Map smeltingList = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry entry : smeltingList.entrySet()) {
            recipesToRemove.add(new ActionFurnaceRemoveRecipe(CraftTweakerMC.getIItemStack((ItemStack)entry.getKey()), CraftTweakerMC.getIItemStack((ItemStack)entry.getValue())));
        }
    }

    @Override
    public void addRecipe(IItemStack output, IIngredient input, @Optional double xp) {
        List<IItemStack> items = input.getItems();
        if (items == null) {
            CraftTweakerAPI.logError("Cannot turn " + input.toString() + " into a furnace recipe");
        }
        ItemStack[] items2 = CraftTweakerMC.getItemStacks(items);
        ItemStack output2 = CraftTweakerMC.getItemStack(output);
        recipesToAdd.add(new ActionAddFurnaceRecipe(input, items2, output2, xp));
    }

    @Override
    public void setFuel(IIngredient item, int fuel) {
        CraftTweakerAPI.apply(new ActionSetFuel(new SetFuelPattern(item, fuel)));
    }

    @Override
    public int getFuel(IItemStack item) {
        return ((ItemStack)item.getInternal()).func_77973_b().getItemBurnTime((ItemStack)item.getInternal());
    }

    @Override
    public List<IFurnaceRecipe> getAll() {
        return FurnaceRecipes.func_77602_a().func_77599_b().entrySet().stream().map(ent -> new FurnaceRecipe(new MCItemStack((ItemStack)ent.getKey()), new MCItemStack((ItemStack)ent.getValue()), FurnaceRecipes.func_77602_a().func_151398_b((ItemStack)ent.getValue()))).collect(Collectors.toList());
    }
}

