/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.game;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.game.IGame;
import crafttweaker.api.item.IItemDefinition;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.potions.IPotion;
import crafttweaker.api.world.IBiome;
import crafttweaker.mc1120.actions.ActionSetTranslation;
import crafttweaker.mc1120.brackets.BracketHandlerItem;
import crafttweaker.mc1120.brackets.BracketHandlerPotion;
import crafttweaker.mc1120.entity.MCEntityDefinition;
import crafttweaker.mc1120.item.MCItemDefinition;
import crafttweaker.mc1120.liquid.MCLiquidDefinition;
import crafttweaker.mc1120.potions.MCPotion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MCGame
implements IGame {
    public static final MCGame INSTANCE = new MCGame();
    private static final Map<String, String> TRANSLATIONS = I18n.field_74839_a.field_74816_c;
    private static final List<IEntityDefinition> ENTITY_DEFINITIONS = new ArrayList<IEntityDefinition>();

    private MCGame() {
    }

    @Override
    public List<IItemDefinition> getItems() {
        return BracketHandlerItem.getItemNames().keySet().stream().map(item -> new MCItemDefinition((String)item, BracketHandlerItem.getItemNames().get(item))).collect(Collectors.toList());
    }

    @Override
    public List<IBlockDefinition> getBlocks() {
        return Block.field_149771_c.func_148742_b().stream().map(block -> CraftTweakerMC.getBlockDefinition((Block)Block.field_149771_c.func_82594_a(block))).collect(Collectors.toList());
    }

    @Override
    public List<ILiquidDefinition> getLiquids() {
        return FluidRegistry.getRegisteredFluids().entrySet().stream().map(entry -> new MCLiquidDefinition((Fluid)entry.getValue())).collect(Collectors.toList());
    }

    @Override
    public List<IBiome> getBiomes() {
        ArrayList<IBiome> result = new ArrayList<IBiome>();
        for (IBiome biome : CraftTweakerMC.biomes) {
            if (biome == null) continue;
            result.add(biome);
        }
        return result;
    }

    @Override
    public List<IPotion> getPotions() {
        ArrayList<IPotion> potions = new ArrayList<IPotion>();
        BracketHandlerPotion.getPotionNames().forEach((s, potion) -> potions.add(new MCPotion((Potion)potion)));
        return potions;
    }

    @Override
    public List<IEntityDefinition> getEntities() {
        if (ENTITY_DEFINITIONS.isEmpty()) {
            ForgeRegistries.ENTITIES.forEach(entry -> ENTITY_DEFINITIONS.add(new MCEntityDefinition((EntityEntry)entry)));
        }
        return ENTITY_DEFINITIONS;
    }

    @Override
    public IEntityDefinition getEntity(String entityName) {
        for (IEntityDefinition ent2 : this.getEntities()) {
            if (!ent2.getName().equalsIgnoreCase(entityName)) continue;
            return ent2;
        }
        boolean needsReloading = false;
        for (ResourceLocation res : ForgeRegistries.ENTITIES.getKeys()) {
            if (!res.func_110623_a().equalsIgnoreCase(entityName)) continue;
            needsReloading = true;
            break;
        }
        if (needsReloading) {
            ENTITY_DEFINITIONS.clear();
            ForgeRegistries.ENTITIES.forEach(entry -> ENTITY_DEFINITIONS.add(new MCEntityDefinition((EntityEntry)entry)));
        }
        return this.getEntities().stream().filter(ent -> ent.getName().equals(entityName)).findFirst().orElse(null);
    }

    @Override
    public void setLocalization(String key, String value) {
        CraftTweakerAPI.apply(new ActionSetTranslation(null, key, value));
    }

    @Override
    public void setLocalization(String lang, String key, String value) {
        CraftTweakerAPI.apply(new ActionSetTranslation(lang, key, value));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String localize(String key) {
        return net.minecraft.client.resources.I18n.func_135052_a((String)key, (Object[])new Object[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String localize(String key, String lang) {
        return net.minecraft.client.resources.I18n.func_135052_a((String)key, (Object[])new Object[0]);
    }

    public static Map<String, String> getTRANSLATIONS() {
        return TRANSLATIONS;
    }
}

