/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.item;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemCondition;
import crafttweaker.api.item.IItemDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IItemTransformer;
import crafttweaker.api.item.IngredientItem;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.api.player.IPlayer;
import crafttweaker.mc1120.actions.ActionSetBlockHardness;
import crafttweaker.mc1120.actions.ActionSetStackMaxDamage;
import crafttweaker.mc1120.actions.ActionSetStackSize;
import crafttweaker.mc1120.actions.ActionSetStackTranslation;
import crafttweaker.mc1120.block.MCItemBlock;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.item.MCItemDefinition;
import crafttweaker.mc1120.liquid.MCLiquidStack;
import crafttweaker.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.OreDictionary;

public class MCItemStack
implements IItemStack {
    private final ItemStack stack;
    private final List<IItemStack> items;
    private IData tag = null;
    private boolean wildcardSize;

    public MCItemStack(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            throw new IllegalArgumentException("stack cannot be null");
        }
        this.stack = itemStack.func_77946_l();
        this.items = Collections.singletonList(this);
    }

    public MCItemStack(ItemStack itemStack, boolean wildcardSize) {
        this(itemStack);
        this.wildcardSize = wildcardSize;
    }

    private MCItemStack(ItemStack itemStack, IData tag) {
        if (itemStack.func_190926_b()) {
            throw new IllegalArgumentException("stack cannot be null");
        }
        this.stack = itemStack;
        this.items = Collections.singletonList(this);
        this.tag = tag;
    }

    private MCItemStack(ItemStack itemStack, IData tag, boolean wildcardSize) {
        if (itemStack.func_190926_b()) {
            throw new IllegalArgumentException("stack cannot be null");
        }
        this.stack = itemStack;
        this.items = Collections.singletonList(this);
        this.tag = tag;
        this.wildcardSize = wildcardSize;
    }

    @Override
    public IItemDefinition getDefinition() {
        return new MCItemDefinition(this.stack.func_77973_b().getRegistryName().toString(), this.stack.func_77973_b());
    }

    @Override
    public String getName() {
        return this.stack.func_77977_a();
    }

    @Override
    public String getDisplayName() {
        return this.stack.func_82833_r();
    }

    @Override
    public void setDisplayName(String name) {
        CraftTweakerAPI.apply(new ActionSetStackTranslation(this, this.getName() + ".name", name));
    }

    @Override
    public int getMaxStackSize() {
        return this.stack.func_77976_d();
    }

    @Override
    public void setMaxStackSize(int size) {
        CraftTweakerAPI.apply(new ActionSetStackSize((ItemStack)this.getInternal(), size));
    }

    @Override
    public float getBlockHardness() {
        return ((Float)ReflectionHelper.getPrivateValue(Block.class, (Object)Block.func_149634_a((Item)this.stack.func_77973_b()), (String[])new String[]{"blockHardness"})).floatValue();
    }

    @Override
    public void setBlockHardness(float hardness) {
        CraftTweakerAPI.apply(new ActionSetBlockHardness(this.stack, hardness));
    }

    @Override
    public int getDamage() {
        return this.stack.func_77952_i();
    }

    @Override
    public IData getTag() {
        if (this.tag == null) {
            if (this.stack.func_77978_p() == null) {
                return DataMap.EMPTY;
            }
            this.tag = NBTConverter.from((NBTBase)this.stack.func_77978_p(), true);
        }
        return this.tag;
    }

    @Override
    public int getMaxDamage() {
        return this.stack.func_77958_k();
    }

    @Override
    public void setMaxDamage(int damage) {
        CraftTweakerAPI.apply(new ActionSetStackMaxDamage(this.stack, damage));
    }

    @Override
    public ILiquidStack getLiquid() {
        FluidStack liquid = FluidUtil.getFluidContained((ItemStack)this.stack);
        return liquid == null ? null : new MCLiquidStack(liquid);
    }

    @Override
    public IIngredient anyDamage() {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), this.stack.func_190916_E(), Short.MAX_VALUE);
        result.func_77982_d(this.stack.func_77978_p());
        return new MCItemStack(result, this.tag);
    }

    @Override
    public IItemStack withDamage(int damage) {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), this.stack.func_190916_E(), damage);
        result.func_77982_d(this.stack.func_77978_p());
        return new MCItemStack(result, this.tag);
    }

    @Override
    public IItemStack anyAmount() {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), 1, this.stack.func_77952_i());
        result.func_77982_d(this.stack.func_77978_p());
        return new MCItemStack(result, this.tag, true);
    }

    @Override
    public IItemStack withAmount(int amount) {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), amount, this.stack.func_77952_i());
        result.func_77982_d(this.stack.func_77978_p());
        return new MCItemStack(result, this.tag);
    }

    @Override
    public IItemStack withTag(IData tag) {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), this.stack.func_190916_E(), this.stack.func_77952_i());
        if (tag == null) {
            result.func_77982_d(null);
        } else {
            result.func_77982_d((NBTTagCompound)NBTConverter.from(tag));
        }
        return new MCItemStack(result, tag);
    }

    @Override
    public IItemStack withEmptyTag() {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), this.stack.func_190916_E(), this.stack.func_77952_i());
        result.func_77982_d(new NBTTagCompound());
        return new MCItemStack(result, NBTConverter.from((NBTBase)new NBTTagCompound(), true));
    }

    @Override
    public IItemStack updateTag(IData tagUpdate) {
        if (this.tag == null) {
            if (this.stack.func_77978_p() == null) {
                return this.withTag(tagUpdate);
            }
            this.tag = NBTConverter.from((NBTBase)this.stack.func_77978_p(), true);
        }
        IData updated = this.tag.update(tagUpdate);
        return this.withTag(updated);
    }

    @Override
    public IItemStack removeTag(String tag) {
        ItemStack result = new ItemStack(this.stack.func_77973_b(), this.stack.func_190916_E(), this.stack.func_77952_i());
        if (tag == null) {
            result.func_77982_d(null);
        } else {
            result.func_77978_p().func_82580_o(tag);
        }
        IData dataTag = NBTConverter.from((NBTBase)result.func_77978_p(), false);
        return new MCItemStack(result, dataTag);
    }

    @Override
    public String getMark() {
        return null;
    }

    @Override
    public int getAmount() {
        return this.stack.func_190916_E();
    }

    @Override
    public List<IItemStack> getItems() {
        return this.items;
    }

    @Override
    public IItemStack[] getItemArray() {
        return this.items.toArray(new IItemStack[this.items.size()]);
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        return Collections.emptyList();
    }

    @Override
    public IItemStack amount(int amount) {
        return this.withAmount(amount);
    }

    @Override
    public WeightedItemStack percent(float chance) {
        return new WeightedItemStack(this, chance * 0.01f);
    }

    @Override
    public WeightedItemStack weight(float chance) {
        return new WeightedItemStack(this, chance);
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientItem(this, null, ArrayUtil.EMPTY_CONDITIONS, new IItemTransformer[]{transformer});
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientItem(this, null, new IItemCondition[]{condition}, ArrayUtil.EMPTY_TRANSFORMERS);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientItem(this, mark, ArrayUtil.EMPTY_CONDITIONS, ArrayUtil.EMPTY_TRANSFORMERS);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public boolean matches(IItemStack item) {
        ItemStack internal = CraftTweakerMC.getItemStack(item);
        if (this.stack.func_77942_o()) {
            return this.matchesExact(item);
        }
        return !internal.func_190926_b() && !this.stack.func_190926_b() && internal.func_77973_b() == this.stack.func_77973_b() && (this.wildcardSize || internal.func_190916_E() >= this.stack.func_190916_E()) && (this.stack.func_77952_i() == Short.MAX_VALUE || this.stack.func_77952_i() == internal.func_77952_i() || !this.stack.func_77981_g() && !this.stack.func_77973_b().func_77645_m());
    }

    @Override
    public boolean matchesExact(IItemStack item) {
        ItemStack internal = CraftTweakerMC.getItemStack(item);
        if (internal.func_77978_p() != null && this.stack.func_77978_p() == null) {
            return false;
        }
        if (internal.func_77978_p() == null && this.stack.func_77978_p() != null) {
            return false;
        }
        if (internal.func_77978_p() == null && this.stack.func_77978_p() == null) {
            return this.stack.func_77973_b() == internal.func_77973_b() && (internal.func_77960_j() == Short.MAX_VALUE || this.stack.func_77960_j() == internal.func_77960_j());
        }
        if (internal.func_77978_p().func_150296_c().equals(this.stack.func_77978_p().func_150296_c())) {
            for (String s : internal.func_77978_p().func_150296_c()) {
                if (internal.func_77978_p().func_74781_a(s).equals((Object)this.stack.func_77978_p().func_74781_a(s))) continue;
                return false;
            }
        }
        return this.stack.func_77973_b() == internal.func_77973_b() && (internal.func_77960_j() == Short.MAX_VALUE || this.stack.func_77960_j() == internal.func_77960_j());
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        return false;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        List<IItemStack> iitems = ingredient.getItems();
        return iitems != null && iitems.size() == 1 && this.matches(iitems.get(0));
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        return item;
    }

    @Override
    public boolean hasTransformers() {
        return false;
    }

    @Override
    public Object getInternal() {
        return this.stack;
    }

    @Override
    public IBlock asBlock() {
        ResourceLocation name = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)Block.func_149634_a((Item)this.stack.func_77973_b()));
        if (Block.field_149771_c.func_148741_d((Object)name)) {
            return new MCItemBlock(this.stack);
        }
        throw new ClassCastException("This item is not a block");
    }

    @Override
    public List<IOreDictEntry> getOres() {
        ArrayList<IOreDictEntry> result = new ArrayList<IOreDictEntry>();
        block0: for (String key : OreDictionary.getOreNames()) {
            for (ItemStack is : OreDictionary.getOres((String)key)) {
                if (is.func_77973_b() != this.stack.func_77973_b() || is.func_77952_i() != Short.MAX_VALUE && is.func_77952_i() != this.stack.func_77952_i()) continue;
                result.add(CraftTweakerAPI.oreDict.get(key));
                continue block0;
            }
        }
        return result;
    }

    @Override
    public IItemStack withDisplayName(String name) {
        NBTTagCompound tagComp = !this.stack.func_77942_o() || this.stack.func_77978_p() == null ? new NBTTagCompound() : this.stack.func_77978_p();
        NBTTagCompound display = !tagComp.func_74764_b("display") || !(tagComp.func_74781_a("display") instanceof NBTTagCompound) ? new NBTTagCompound() : (NBTTagCompound)tagComp.func_74781_a("display");
        display.func_74778_a("Name", name);
        tagComp.func_74782_a("display", (NBTBase)display);
        ItemStack newStack = this.stack.func_77946_l();
        newStack.func_77982_d(tagComp);
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack withLore(String[] lore) {
        NBTTagCompound tagComp = !this.stack.func_77942_o() || this.stack.func_77978_p() == null ? new NBTTagCompound() : this.stack.func_77978_p();
        NBTTagCompound display = !tagComp.func_74764_b("display") || !(tagComp.func_74781_a("display") instanceof NBTTagCompound) ? new NBTTagCompound() : (NBTTagCompound)tagComp.func_74781_a("display");
        NBTTagList loreList = !tagComp.func_74764_b("Lore") || !(tagComp.func_74781_a("Lore") instanceof NBTTagList) ? new NBTTagList() : (NBTTagList)tagComp.func_74781_a("Lore");
        for (String s : lore) {
            loreList.func_74742_a((NBTBase)new NBTTagString(s));
        }
        display.func_74782_a("Lore", (NBTBase)loreList);
        tagComp.func_74782_a("display", (NBTBase)display);
        ItemStack newStack = this.stack.func_77946_l();
        newStack.func_77982_d(tagComp);
        return new MCItemStack(newStack);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.stack.func_77973_b().hashCode();
        hash = 41 * hash + this.stack.func_77952_i();
        hash = 41 * hash + this.stack.func_190916_E();
        hash = 41 * hash + (this.stack.func_77978_p() == null ? 0 : this.stack.func_77978_p().hashCode());
        hash = 41 * hash + (this.wildcardSize ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MCItemStack other = (MCItemStack)obj;
        return this.stack.func_77973_b() == other.stack.func_77973_b() && this.stack.func_77952_i() == other.stack.func_77952_i() && this.stack.func_190916_E() == other.stack.func_190916_E() && (this.stack.func_77978_p() == other.stack.func_77978_p() || !this.stack.equals(other.stack)) && this.wildcardSize == other.wildcardSize;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('<');
        result.append(Item.field_150901_e.func_177774_c((Object)this.stack.func_77973_b()));
        if (this.stack.func_77952_i() == Short.MAX_VALUE) {
            result.append(":*");
        } else if (this.stack.func_77952_i() > 0) {
            result.append(':').append(this.stack.func_77952_i());
        }
        result.append('>');
        if (this.stack.func_77978_p() != null) {
            result.append(".withTag(");
            result.append(NBTConverter.from((NBTBase)this.stack.func_77978_p(), this.wildcardSize).toString());
            result.append(")");
        }
        if (!this.wildcardSize && this.stack.func_190916_E() > 1) {
            result.append(" * ").append(this.stack.func_190916_E());
        }
        return result.toString();
    }
}

