/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.oredict;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemCondition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IItemTransformer;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.api.oredict.IngredientOreDict;
import crafttweaker.api.player.IPlayer;
import crafttweaker.mc1120.actions.ActionOreDictAddAll;
import crafttweaker.mc1120.actions.ActionOreDictAddItem;
import crafttweaker.mc1120.actions.ActionOreDictMirror;
import crafttweaker.mc1120.actions.ActionOreDictRemoveItem;
import crafttweaker.mc1120.util.CraftTweakerHacks;
import crafttweaker.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class MCOreDictEntry
implements IOreDictEntry {
    private static final List<NonNullList<ItemStack>> OREDICT_CONTENTS = CraftTweakerHacks.getOreIdStacks();
    private static final List<NonNullList<ItemStack>> OREDICT_CONTENTS_UN = CraftTweakerHacks.getOreIdStacksUn();
    private final String id;

    public MCOreDictEntry(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public boolean isEmpty() {
        return OreDictionary.getOres((String)this.getName()).isEmpty();
    }

    @Override
    public IItemStack getFirstItem() {
        return this.getItems().get(0);
    }

    @Override
    public void add(IItemStack item) {
        ItemStack stack = CraftTweakerMC.getItemStack(item);
        if (!stack.func_190926_b()) {
            CraftTweakerAPI.apply(new ActionOreDictAddItem(this.id, stack));
        }
    }

    @Override
    public void addItems(IItemStack[] items) {
        for (IItemStack item : items) {
            ItemStack stack = CraftTweakerMC.getItemStack(item);
            if (stack.func_190926_b()) continue;
            CraftTweakerAPI.apply(new ActionOreDictAddItem(this.id, stack));
        }
    }

    @Override
    public void addAll(IOreDictEntry entry) {
        if (entry instanceof MCOreDictEntry) {
            CraftTweakerAPI.apply(new ActionOreDictAddAll(this.id, ((MCOreDictEntry)entry).id));
        } else {
            CraftTweakerAPI.logError("not a valid entry");
        }
    }

    @Override
    public void remove(IItemStack item) {
        ItemStack result = ItemStack.field_190927_a;
        for (ItemStack itemStack : OreDictionary.getOres((String)this.getName())) {
            if (!item.matches(CraftTweakerMC.getIItemStackWildcardSize(itemStack))) continue;
            result = itemStack;
            break;
        }
        if (!result.func_190926_b()) {
            CraftTweakerAPI.apply(new ActionOreDictRemoveItem(this.id, result));
        }
    }

    @Override
    public void removeItems(IItemStack[] items) {
        for (IItemStack item : items) {
            ItemStack result = ItemStack.field_190927_a;
            for (ItemStack itemStack : OreDictionary.getOres((String)this.id)) {
                if (!item.matches(CraftTweakerMC.getIItemStackWildcardSize(itemStack))) continue;
                result = itemStack;
                break;
            }
            if (result.func_190926_b()) continue;
            CraftTweakerAPI.apply(new ActionOreDictRemoveItem(this.id, result));
        }
    }

    @Override
    public boolean contains(IItemStack item) {
        for (ItemStack itemStack : OreDictionary.getOres((String)this.getName())) {
            if (!CraftTweakerMC.getIItemStackWildcardSize(itemStack).matches(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mirror(IOreDictEntry other) {
        if (other instanceof MCOreDictEntry) {
            CraftTweakerAPI.apply(new ActionOreDictMirror(this.id, ((MCOreDictEntry)other).id));
        } else {
            CraftTweakerAPI.logError("not a valid oredict entry");
        }
    }

    @Override
    public String getMark() {
        return null;
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public List<IItemStack> getItems() {
        return OreDictionary.getOres((String)this.getName()).stream().map(CraftTweakerMC::getIItemStackWildcardSize).collect(Collectors.toList());
    }

    @Override
    public IItemStack[] getItemArray() {
        List<IItemStack> items = this.getItems();
        return items.toArray(new IItemStack[items.size()]);
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        return Collections.emptyList();
    }

    @Override
    public IIngredient amount(int amount) {
        return new IngredientStack(this, amount);
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientOreDict(this, null, ArrayUtil.EMPTY_CONDITIONS, new IItemTransformer[]{transformer});
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientOreDict(this, null, new IItemCondition[]{condition}, ArrayUtil.EMPTY_TRANSFORMERS);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientOreDict(this, mark, ArrayUtil.EMPTY_CONDITIONS, ArrayUtil.EMPTY_TRANSFORMERS);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public boolean matches(IItemStack item) {
        return this.contains(item);
    }

    @Override
    public boolean matchesExact(IItemStack item) {
        return this.contains(item);
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        return false;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        List<IItemStack> items = ingredient.getItems();
        for (IItemStack item : items) {
            if (this.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        return item;
    }

    @Override
    public boolean hasTransformers() {
        return false;
    }

    @Override
    public Object getInternal() {
        return this.id;
    }

    public String toString() {
        return "<ore:" + this.id + ">";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof MCOreDictEntry && Objects.equals(((MCOreDictEntry)other).id, this.id);
    }

    public static List<NonNullList<ItemStack>> getOredictContents() {
        return OREDICT_CONTENTS;
    }

    public static List<NonNullList<ItemStack>> getOredictContentsUn() {
        return OREDICT_CONTENTS_UN;
    }

    public String getId() {
        return this.id;
    }
}

