/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.player;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.chat.IChatMessage;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.util.Position3f;
import crafttweaker.mc1120.CraftTweaker;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.entity.MCEntityLivingBase;
import crafttweaker.mc1120.network.MessageCopyClipboard;
import crafttweaker.mc1120.network.MessageOpenBrowser;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MCPlayer
extends MCEntityLivingBase
implements IPlayer {
    private final EntityPlayer player;

    public MCPlayer(EntityPlayer player) {
        super((EntityLivingBase)player);
        this.player = player;
    }

    public EntityPlayer getInternal() {
        return this.player;
    }

    @Override
    public String getId() {
        return this.player.func_110124_au().toString();
    }

    @Override
    public String getName() {
        return this.player.func_70005_c_();
    }

    @Override
    public IData getData() {
        return NBTConverter.from((NBTBase)this.player.getEntityData(), true);
    }

    @Override
    public int getXP() {
        return this.player.field_71068_ca;
    }

    @Override
    public void setXP(int xp) {
        this.player.func_82242_a(-this.player.field_71068_ca);
        this.player.func_82242_a(xp);
    }

    @Override
    public void removeXP(int xp) {
        this.player.func_71023_q(-xp);
    }

    @Override
    public void update(IData data) {
        NBTConverter.updateMap(this.player.getEntityData(), data);
    }

    @Override
    public void sendChat(IChatMessage message) {
        Object internal = message.getInternal();
        if (!(internal instanceof ITextComponent)) {
            CraftTweakerAPI.logError("not a valid chat message");
            return;
        }
        this.player.func_145747_a((ITextComponent)internal);
    }

    @Override
    public void sendChat(String message) {
        this.player.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    @Override
    public int getHotbarSize() {
        return 9;
    }

    @Override
    public IItemStack getHotbarStack(int i) {
        return i < 0 || i >= 9 ? null : CraftTweakerMC.getIItemStack(this.player.field_71071_by.func_70301_a(i));
    }

    @Override
    public int getInventorySize() {
        return this.player.field_71071_by.func_70302_i_();
    }

    @Override
    public IItemStack getInventoryStack(int i) {
        return CraftTweakerMC.getIItemStack(this.player.field_71071_by.func_70301_a(i));
    }

    @Override
    public IItemStack getCurrentItem() {
        return CraftTweakerMC.getIItemStack(this.player.field_71071_by.func_70448_g());
    }

    @Override
    public boolean isCreative() {
        return this.player.field_71075_bZ.field_75098_d;
    }

    @Override
    public boolean isAdventure() {
        return !this.player.field_71075_bZ.field_75099_e;
    }

    @Override
    public void openBrowser(String url) {
        if (this.player instanceof EntityPlayerMP) {
            CraftTweaker.NETWORK.sendTo((IMessage)new MessageOpenBrowser(url), (EntityPlayerMP)this.player);
        }
    }

    @Override
    public void copyToClipboard(String value) {
        if (this.player instanceof EntityPlayerMP) {
            CraftTweaker.NETWORK.sendTo((IMessage)new MessageCopyClipboard(value), (EntityPlayerMP)this.player);
        }
    }

    public boolean equals(Object other) {
        return other.getClass() == this.getClass() && ((MCPlayer)other).player == this.player;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.player != null ? this.player.hashCode() : 0);
        return hash;
    }

    @Override
    public void give(IItemStack stack) {
        ItemStack itemstack = CraftTweakerMC.getItemStack(stack).func_77946_l();
        boolean flag = this.player.field_71071_by.func_70441_a(itemstack);
        if (flag) {
            this.player.field_70170_p.func_184148_a(null, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.player.func_70681_au().nextFloat() - this.player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.player.field_71069_bz.func_75142_b();
        }
        if (flag && itemstack.func_190926_b()) {
            itemstack.func_190920_e(1);
            EntityItem entityitem1 = this.player.func_71019_a(itemstack, false);
            if (entityitem1 != null) {
                entityitem1.func_174870_v();
            }
        } else {
            EntityItem entityitem = this.player.func_71019_a(itemstack, false);
            if (entityitem != null) {
                entityitem.func_174868_q();
                entityitem.func_145797_a(this.player.func_70005_c_());
            }
        }
    }

    @Override
    public double getX() {
        return this.player.field_70165_t;
    }

    @Override
    public double getY() {
        return this.player.field_70163_u;
    }

    @Override
    public double getZ() {
        return this.player.field_70161_v;
    }

    @Override
    public Position3f getPosition() {
        return new Position3f((float)this.getX(), (float)this.getY(), (float)this.getZ());
    }

    @Override
    public void teleport(Position3f pos) {
        this.player.func_70107_b((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    @Override
    public int getScore() {
        return this.player.func_71037_bA();
    }

    @Override
    public void addScore(int amount) {
        this.player.func_85039_t(amount);
    }

    @Override
    public void setScore(int amount) {
        this.player.func_85040_s(amount);
    }
}

