/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mods.jei.actions;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mods.jei.JEIAddonPlugin;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeAction
implements IAction {
    private final List<Object> stack;
    private final String[] description;
    private final String name;

    @Deprecated
    public DescribeAction(IItemStack stack, String[] description) {
        this(Collections.singletonList(stack), description, stack.toString());
    }

    public DescribeAction(List<? extends IIngredient> stack, String[] description, String name) {
        this.stack = stack.stream().map(item -> item.getInternal()).collect(Collectors.toList());
        this.description = description;
        this.name = name;
    }

    @Override
    public void apply() {
        if (this.stack.isEmpty()) {
            CraftTweakerAPI.logError(this.name + " is empty!");
            return;
        }
        if (!this.checkClasses()) {
            CraftTweakerAPI.logError(this.name + " needs to consist only of items of the same type!");
            return;
        }
        JEIAddonPlugin.modRegistry.addIngredientInfo(this.stack, this.stack.get(0).getClass(), this.description);
    }

    @Override
    public String describe() {
        return "Adding description in JEI for: " + this.name;
    }

    public boolean checkClasses() {
        Class<?> clazz = this.stack.get(0).getClass();
        return this.stack.stream().map(item -> item.getClass()).allMatch(i -> i == clazz);
    }
}

