/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.runtime;

import crafttweaker.api.network.NetworkSide;
import crafttweaker.preprocessor.IPreprocessor;
import crafttweaker.runtime.IScriptIterator;
import crafttweaker.runtime.ITweaker;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ScriptFile {
    private IScriptIterator script;
    private List<IPreprocessor> affectingPreprocessors = new ArrayList<IPreprocessor>();
    private ITweaker tweaker;
    private int priority = 0;
    private String loaderName = "crafttweaker";
    private boolean isExecutionBlocked = false;
    private boolean isParsingBlocked = false;
    private boolean isCompileBlocked = false;
    private boolean isDebugEnabled = false;
    private boolean ignoreBracketErrors = false;
    private boolean isSyntaxCommand;
    private NetworkSide networkSide;

    public ScriptFile(ITweaker tweaker, IScriptIterator script, boolean isSyntaxCommand) {
        this.tweaker = tweaker;
        this.script = script;
        this.isSyntaxCommand = isSyntaxCommand;
    }

    public IScriptIterator getScript() {
        return this.script;
    }

    public String getGroupName() {
        return this.script.getGroupName();
    }

    public String getName() {
        return this.script.getName();
    }

    public String getEffectiveName() {
        if (this.script.getGroupName().endsWith(".zip")) {
            return this.getGroupName() + "$" + this.getName();
        }
        return this.getGroupName();
    }

    public InputStream open() throws IOException {
        return this.script.open();
    }

    public boolean add(IPreprocessor preprocessor) {
        return this.affectingPreprocessors.add(preprocessor);
    }

    public boolean addAll(Collection<? extends IPreprocessor> c) {
        return this.affectingPreprocessors.addAll(c);
    }

    public List<IPreprocessor> getAffectingPreprocessors() {
        return this.affectingPreprocessors;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getLoaderName() {
        return this.loaderName;
    }

    public void setLoaderName(String loaderName) {
        this.loaderName = loaderName;
    }

    public ITweaker getTweaker() {
        return this.tweaker;
    }

    public boolean isExecutionBlocked() {
        return this.isExecutionBlocked;
    }

    public void setExecutionBlocked(boolean executionBlocked) {
        this.isExecutionBlocked = executionBlocked;
    }

    public boolean isParsingBlocked() {
        return this.isParsingBlocked;
    }

    public void setParsingBlocked(boolean parsingBlocked) {
        this.isParsingBlocked = parsingBlocked;
    }

    public boolean isCompileBlocked() {
        return this.isCompileBlocked;
    }

    public void setCompileBlocked(boolean compileBlocked) {
        this.isCompileBlocked = compileBlocked;
    }

    public boolean isSyntaxCommand() {
        return this.isSyntaxCommand;
    }

    public String toString() {
        return "{[" + this.priority + ":" + this.loaderName + "]: " + this.getEffectiveName() + (this.networkSide == null ? "" : "[Side: " + (Object)((Object)this.networkSide) + "]") + "}";
    }

    public boolean areBracketErrorsIgnored() {
        return this.ignoreBracketErrors;
    }

    public void setIgnoreBracketErrors(boolean ignoreBracketErrors) {
        this.ignoreBracketErrors = ignoreBracketErrors;
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.isDebugEnabled = debugEnabled;
    }

    public void setNetworkSide(NetworkSide networkSide) {
        this.networkSide = networkSide;
    }

    public boolean shouldBeLoadedOn(NetworkSide proposedSide) {
        return this.networkSide == null || this.networkSide.equals((Object)proposedSide);
    }
}

