/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.zenscript;

import crafttweaker.runtime.GlobalFunctions;
import crafttweaker.zenscript.CrTCompileEnvironment;
import crafttweaker.zenscript.CrTErrorLogger;
import crafttweaker.zenscript.CrTGlobalEnvironment;
import crafttweaker.zenscript.IBracketHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import stanhebben.zenscript.IZenCompileEnvironment;
import stanhebben.zenscript.IZenErrorLogger;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.TypeRegistry;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolJavaStaticField;
import stanhebben.zenscript.symbols.SymbolJavaStaticMethod;
import stanhebben.zenscript.symbols.SymbolPackage;
import stanhebben.zenscript.symbols.SymbolType;
import stanhebben.zenscript.type.ZenTypeNative;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;

public class GlobalRegistry {
    private static final Map<String, IZenSymbol> globals = new HashMap<String, IZenSymbol>();
    private static final List<IBracketHandler> bracketHandlers = new ArrayList<IBracketHandler>();
    private static final TypeRegistry types = new TypeRegistry();
    private static final SymbolPackage root = new SymbolPackage("<root>");
    private static final IZenErrorLogger errors = new CrTErrorLogger();
    private static final IZenCompileEnvironment environment = new CrTCompileEnvironment();
    private static final Map<String, TypeExpansion> expansions = new HashMap<String, TypeExpansion>();

    private GlobalRegistry() {
    }

    public static void registerGlobal(String name, IZenSymbol symbol) {
        if (globals.containsKey(name)) {
            throw new IllegalArgumentException("symbol already exists: " + name);
        }
        globals.put(name, symbol);
    }

    public static void registerExpansion(Class<?> cls) {
        try {
            for (Annotation annotation : cls.getAnnotations()) {
                if (!(annotation instanceof ZenExpansion)) continue;
                ZenExpansion eAnnotation = (ZenExpansion)annotation;
                if (!expansions.containsKey(eAnnotation.value())) {
                    expansions.put(eAnnotation.value(), new TypeExpansion(eAnnotation.value()));
                }
                expansions.get(eAnnotation.value()).expand(cls, types);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void registerBracketHandler(IBracketHandler handler) {
        bracketHandlers.add(handler);
    }

    public static void removeBracketHandler(IBracketHandler handler) {
        bracketHandlers.remove(handler);
    }

    public static void registerNativeClass(Class<?> cls) {
        try {
            ZenTypeNative type = new ZenTypeNative(cls);
            type.complete(types);
            root.put(type.getName(), new SymbolType(type), errors);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static IZenSymbol resolveBracket(IEnvironmentGlobal environment, List<Token> tokens) {
        for (IBracketHandler handler : bracketHandlers) {
            IZenSymbol symbol = handler.resolve(environment, tokens);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    public static IZenSymbol getStaticFunction(Class cls, String name, Class ... arguments) {
        IJavaMethod method = JavaMethod.get(types, cls, name, arguments);
        return new SymbolJavaStaticMethod(method);
    }

    public static IZenSymbol getStaticField(Class cls, String name) {
        try {
            Field field = cls.getDeclaredField(name);
            return new SymbolJavaStaticField(cls, field, types);
        }
        catch (NoSuchFieldException | SecurityException ex) {
            Logger.getLogger(GlobalRegistry.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static IEnvironmentGlobal makeGlobalEnvironment(Map<String, byte[]> classes) {
        return new CrTGlobalEnvironment(classes);
    }

    public static Map<String, IZenSymbol> getGlobals() {
        return globals;
    }

    public static List<IBracketHandler> getBracketHandlers() {
        return bracketHandlers;
    }

    public static TypeRegistry getTypes() {
        return types;
    }

    public static SymbolPackage getRoot() {
        return root;
    }

    public static IZenErrorLogger getErrors() {
        return errors;
    }

    public static IZenCompileEnvironment getEnvironment() {
        return environment;
    }

    public static Map<String, TypeExpansion> getExpansions() {
        return expansions;
    }

    static {
        GlobalRegistry.registerGlobal("print", GlobalRegistry.getStaticFunction(GlobalFunctions.class, "print", String.class));
        GlobalRegistry.registerGlobal("totalActions", GlobalRegistry.getStaticFunction(GlobalFunctions.class, "totalActions", new Class[0]));
        GlobalRegistry.registerGlobal("enableDebug", GlobalRegistry.getStaticFunction(GlobalFunctions.class, "enableDebug", new Class[0]));
        GlobalRegistry.registerGlobal("isNull", GlobalRegistry.getStaticFunction(GlobalFunctions.class, "isNull", Object.class));
        GlobalRegistry.registerGlobal("max", GlobalRegistry.getStaticFunction(Math.class, "max", Integer.TYPE, Integer.TYPE));
        GlobalRegistry.registerGlobal("min", GlobalRegistry.getStaticFunction(Math.class, "min", Integer.TYPE, Integer.TYPE));
        GlobalRegistry.registerGlobal("pow", GlobalRegistry.getStaticFunction(Math.class, "pow", Double.TYPE, Double.TYPE));
    }
}

