/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.compiler;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import stanhebben.zenscript.IZenCompileEnvironment;
import stanhebben.zenscript.IZenErrorLogger;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.compiler.ClassNameGenerator;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.TypeRegistry;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.ZenPosition;

public class EnvironmentGlobal
implements IEnvironmentGlobal {
    private final IZenCompileEnvironment environment;
    private final IZenErrorLogger errors;
    private final Map<String, byte[]> classes;
    private final Map<String, IZenSymbol> local;
    private final ClassNameGenerator nameGen;
    private final TypeRegistry types;

    public EnvironmentGlobal(IZenCompileEnvironment environment, Map<String, byte[]> classes, ClassNameGenerator nameGen) {
        this.environment = environment;
        this.errors = environment.getErrorLogger();
        this.classes = classes;
        this.nameGen = nameGen;
        this.types = environment.getTypeRegistry();
        this.local = new HashMap<String, IZenSymbol>();
    }

    public IZenCompileEnvironment getCompileEnvironment() {
        return this.environment;
    }

    @Override
    public ZenType getType(Type type) {
        return this.types.getType(type);
    }

    @Override
    public boolean containsClass(String name) {
        return this.classes.containsKey(name);
    }

    @Override
    public void putClass(String name, byte[] data) {
        this.classes.put(name, data);
    }

    @Override
    public String makeClassName() {
        return this.nameGen.generate();
    }

    @Override
    public TypeExpansion getExpansion(String type) {
        return this.environment.getExpansion(type);
    }

    @Override
    public void error(ZenPosition position, String message) {
        this.errors.error(position, message);
    }

    @Override
    public void warning(ZenPosition position, String message) {
        this.errors.warning(position, message);
    }

    @Override
    public void info(ZenPosition position, String message) {
        this.errors.info(position, message);
    }

    @Override
    public IZenCompileEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public IPartialExpression getValue(String name, ZenPosition position) {
        if (this.local.containsKey(name)) {
            return this.local.get(name).instance(position);
        }
        IZenSymbol symbol = this.environment.getGlobal(name);
        return symbol == null ? null : symbol.instance(position);
    }

    @Override
    public void putValue(String name, IZenSymbol value, ZenPosition position) {
        if (this.local.containsKey(name)) {
            this.error(position, "Value already defined in this scope: " + name);
        } else {
            this.local.put(name, value);
        }
    }

    @Override
    public Set<String> getClassNames() {
        return this.classes.keySet();
    }

    @Override
    public byte[] getClass(String name) {
        return this.classes.get(name);
    }
}

