/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression;

import java.lang.reflect.Method;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.ZenPosition;

public class ExpressionStringMethod
extends Expression {
    private final Expression source;
    private final String methodName;
    private final Class<?> returnClass;
    private final ZenType type;

    public ExpressionStringMethod(ZenPosition position, Expression expression, String method, IEnvironmentGlobal environment) {
        super(position);
        this.source = expression;
        this.methodName = method;
        this.returnClass = ExpressionStringMethod.getMethod(method).getReturnType();
        this.type = environment.getType(this.returnClass);
    }

    @Override
    public ZenType getType() {
        return this.type;
    }

    @Override
    public void compile(boolean result, IEnvironmentMethod environment) {
        this.source.compile(result, environment);
        environment.getOutput().invokeVirtual(String.class, this.methodName, this.returnClass, new Class[0]);
    }

    private static Method getMethod(String name) {
        try {
            return String.class.getMethod(name, null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static boolean hasMethod(String name) {
        return ExpressionStringMethod.getMethod(name) != null;
    }
}

