/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionArrayAdd;
import stanhebben.zenscript.expression.ExpressionArrayGet;
import stanhebben.zenscript.expression.ExpressionArrayLength;
import stanhebben.zenscript.expression.ExpressionArraySet;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeArray;
import stanhebben.zenscript.type.ZenTypeArrayList;
import stanhebben.zenscript.type.casting.CastingRuleArrayArray;
import stanhebben.zenscript.type.casting.CastingRuleArrayList;
import stanhebben.zenscript.type.casting.CastingRuleDelegateArray;
import stanhebben.zenscript.type.casting.ICastingRule;
import stanhebben.zenscript.type.casting.ICastingRuleDelegate;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;

public class ZenTypeArrayBasic
extends ZenTypeArray {
    private final Type asmType;

    public ZenTypeArrayBasic(ZenType base) {
        super(base);
        this.asmType = Type.getType((String)("[" + base.toASMType().getDescriptor()));
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ZenTypeArrayBasic) {
            ZenTypeArrayBasic o = (ZenTypeArrayBasic)other;
            return o.getBaseType().equals(this.getBaseType());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.getBaseType() != null ? this.getBaseType().hashCode() : 0);
        return hash;
    }

    @Override
    public ICastingRule getCastingRule(ZenType type, IEnvironmentGlobal environment) {
        ICastingRule base = super.getCastingRule(type, environment);
        if (base == null && this.getBaseType() == ANY && type instanceof ZenTypeArray) {
            ZenType toBaseType = ((ZenTypeArray)type).getBaseType();
            if (type instanceof ZenTypeArrayBasic) {
                return new CastingRuleArrayArray(ANY.getCastingRule(toBaseType, environment), this, (ZenTypeArrayBasic)type);
            }
            if (type instanceof ZenTypeArrayList) {
                return new CastingRuleArrayList(ANY.getCastingRule(toBaseType, environment), this, (ZenTypeArrayList)type);
            }
            throw new RuntimeException("Invalid array type: " + type);
        }
        return base;
    }

    @Override
    public void constructCastingRules(IEnvironmentGlobal environment, ICastingRuleDelegate rules, boolean followCasters) {
        CastingRuleDelegateArray arrayRules = new CastingRuleDelegateArray(rules, this);
        this.getBaseType().constructCastingRules(environment, arrayRules, followCasters);
        if (followCasters) {
            this.constructExpansionCastingRules(environment, rules);
        }
    }

    @Override
    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        if (numValues == 1) {
            return new ValueIterator(methodOutput.getOutput());
        }
        if (numValues == 2) {
            return new IndexValueIterator(methodOutput.getOutput());
        }
        return null;
    }

    @Override
    public String getAnyClassName(IEnvironmentGlobal global) {
        return null;
    }

    @Override
    public Type toASMType() {
        return this.asmType;
    }

    @Override
    public Class toJavaClass() {
        try {
            if (this.getBaseType().toJavaClass().isArray()) {
                return Class.forName("[" + this.getBaseType().toJavaClass().getName());
            }
            if (this.getBaseType().toJavaClass().isPrimitive()) {
                return Class.forName("[" + ZenTypeUtil.signature(this.getBaseType().toJavaClass()));
            }
            return Class.forName("[L" + this.getBaseType().toJavaClass().getName() + ";");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getSignature() {
        return "[" + this.getBaseType().getSignature();
    }

    @Override
    public IPartialExpression getMemberLength(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value) {
        return new ExpressionArrayLength(position, value.eval(environment));
    }

    @Override
    public Expression indexGet(ZenPosition position, IEnvironmentGlobal environment, Expression array, Expression index) {
        return new ExpressionArrayGet(position, array, index.cast(position, environment, INT));
    }

    @Override
    public Expression indexSet(ZenPosition position, IEnvironmentGlobal environment, Expression array, Expression index, Expression value) {
        return new ExpressionArraySet(position, array, index.cast(position, environment, INT), value.cast(position, environment, this.getBaseType()));
    }

    @Override
    public Expression add(ZenPosition position, IEnvironmentGlobal environment, Expression array, Expression val) {
        return new ExpressionArrayAdd(position, environment, array, val);
    }

    private class IndexValueIterator
    implements IZenIterator {
        private final MethodOutput methodOutput;

        public IndexValueIterator(MethodOutput methodOutput) {
            this.methodOutput = methodOutput;
        }

        @Override
        public void compileStart(int[] locals) {
            this.methodOutput.iConst0();
            this.methodOutput.storeInt(locals[0]);
        }

        @Override
        public void compilePreIterate(int[] locals, Label exit) {
            this.methodOutput.dup();
            this.methodOutput.arrayLength();
            this.methodOutput.loadInt(locals[0]);
            this.methodOutput.ifICmpLE(exit);
            this.methodOutput.dup();
            this.methodOutput.loadInt(locals[0]);
            this.methodOutput.arrayLoad(ZenTypeArrayBasic.this.getBaseType().toASMType());
            this.methodOutput.store(ZenTypeArrayBasic.this.getBaseType().toASMType(), locals[1]);
        }

        @Override
        public void compilePostIterate(int[] locals, Label exit, Label repeat) {
            this.methodOutput.iinc(locals[0]);
            this.methodOutput.goTo(repeat);
        }

        @Override
        public void compileEnd() {
            this.methodOutput.pop();
        }

        @Override
        public ZenType getType(int i) {
            return i == 0 ? ZenType.INT : ZenTypeArrayBasic.this.getBaseType();
        }
    }

    private class ValueIterator
    implements IZenIterator {
        private final MethodOutput methodOutput;
        private int index;

        public ValueIterator(MethodOutput methodOutput) {
            this.methodOutput = methodOutput;
        }

        @Override
        public void compileStart(int[] locals) {
            this.index = this.methodOutput.local(Type.INT_TYPE);
            this.methodOutput.iConst0();
            this.methodOutput.storeInt(this.index);
        }

        @Override
        public void compilePreIterate(int[] locals, Label exit) {
            this.methodOutput.dup();
            this.methodOutput.arrayLength();
            this.methodOutput.loadInt(this.index);
            this.methodOutput.ifICmpLE(exit);
            this.methodOutput.dup();
            this.methodOutput.loadInt(this.index);
            this.methodOutput.arrayLoad(ZenTypeArrayBasic.this.getBaseType().toASMType());
            this.methodOutput.store(ZenTypeArrayBasic.this.getBaseType().toASMType(), locals[0]);
        }

        @Override
        public void compilePostIterate(int[] locals, Label exit, Label repeat) {
            this.methodOutput.iinc(this.index, 1);
            this.methodOutput.goTo(repeat);
        }

        @Override
        public void compileEnd() {
            this.methodOutput.pop();
        }

        @Override
        public ZenType getType(int i) {
            return ZenTypeArrayBasic.this.getBaseType();
        }
    }
}

