/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import java.util.List;
import org.objectweb.asm.Type;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionArrayListAdd;
import stanhebben.zenscript.expression.ExpressionArrayListGet;
import stanhebben.zenscript.expression.ExpressionArrayListSet;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeArray;
import stanhebben.zenscript.type.ZenTypeInt;
import stanhebben.zenscript.type.casting.CastingRuleDelegateList;
import stanhebben.zenscript.type.casting.ICastingRuleDelegate;
import stanhebben.zenscript.type.iterator.IteratorIterable;
import stanhebben.zenscript.type.iterator.IteratorList;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;

public class ZenTypeArrayList
extends ZenTypeArray {
    private final Type type = Type.getType(List.class);

    public ZenTypeArrayList(ZenType baseType) {
        super(baseType);
    }

    @Override
    public IPartialExpression getMemberLength(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value) {
        return new ExpressionListLength(position, value.eval(environment));
    }

    @Override
    public void constructCastingRules(IEnvironmentGlobal environment, ICastingRuleDelegate rules, boolean followCasters) {
        CastingRuleDelegateList arrayRules = new CastingRuleDelegateList(rules, this);
        this.getBaseType().constructCastingRules(environment, arrayRules, followCasters);
        if (followCasters) {
            this.constructExpansionCastingRules(environment, rules);
        }
    }

    @Override
    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        if (numValues == 1) {
            return new IteratorIterable(methodOutput.getOutput(), this.getBaseType());
        }
        if (numValues == 2) {
            return new IteratorList(methodOutput.getOutput(), this.getBaseType());
        }
        return null;
    }

    @Override
    public Class toJavaClass() {
        return List.class;
    }

    @Override
    public String getAnyClassName(IEnvironmentGlobal global) {
        return null;
    }

    @Override
    public Type toASMType() {
        return Type.getType(List.class);
    }

    @Override
    public String getSignature() {
        return ZenTypeUtil.signature(List.class);
    }

    @Override
    public Expression indexGet(ZenPosition position, IEnvironmentGlobal environment, Expression array, Expression index) {
        return new ExpressionArrayListGet(position, array, index);
    }

    @Override
    public Expression indexSet(ZenPosition position, IEnvironmentGlobal environment, Expression array, Expression index, Expression value) {
        return new ExpressionArrayListSet(position, array, index, value);
    }

    @Override
    public Expression add(ZenPosition position, IEnvironmentGlobal environment, Expression array, Expression val) {
        return new ExpressionArrayListAdd(position, environment, array, val);
    }

    private class ExpressionListLength
    extends Expression {
        private final Expression value;

        public ExpressionListLength(ZenPosition position, Expression value) {
            super(position);
            this.value = value;
        }

        @Override
        public ZenType getType() {
            return ZenTypeInt.INSTANCE;
        }

        @Override
        public void compile(boolean result, IEnvironmentMethod environment) {
            this.value.compile(result, environment);
            if (result) {
                environment.getOutput().invokeInterface(List.class, "size", Integer.TYPE, new Class[0]);
            }
        }
    }
}

