/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;

public class StringUtil {
    private StringUtil() {
    }

    public static String join(String[] values, String separator) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String value : values) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(value);
        }
        return result.toString();
    }

    public static String join(Iterable<String> values, String separator) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String value : values) {
            if (first) {
                first = false;
            } else {
                result.append('.');
            }
            result.append(value);
        }
        return result.toString();
    }

    public static String methodMatchingError(List<IJavaMethod> methods, Expression ... arguments) {
        if (methods.isEmpty()) {
            return "\u00a7cno method with that name available";
        }
        StringBuilder message = new StringBuilder();
        if (methods.size() == 1) {
            message.append("a method ");
        } else {
            message.append(methods.size()).append(" methods ");
        }
        message.append("available but \u00a74none\u00a7r matches the parameters (");
        boolean first = true;
        for (Expression value : arguments) {
            if (first) {
                first = false;
            } else {
                message.append(", ");
            }
            message.append(value.getType().toString());
        }
        message.append(")");
        message.append("\nThis is \u00a7ousually\u00a7r an error in your script, not in the mod");
        methods.forEach(meth -> {
            if (meth instanceof JavaMethod) {
                JavaMethod m = (JavaMethod)meth;
                message.append("\n").append(m.getMethod().getName()).append("(");
                for (int i = 0; i < m.getParameterTypes().length; ++i) {
                    ZenType type = m.getParameterTypes()[i];
                    for (int i1 = 0; i1 < m.getMethod().getParameterAnnotations()[i].length; ++i1) {
                        Annotation an = m.getMethod().getParameterAnnotations()[i][i1];
                        message.append("\u00a7a").append(an.annotationType().getSimpleName()).append(" ");
                    }
                    message.append("\u00a7r").append(type.toString()).append(", ");
                }
                message.deleteCharAt(message.length() - 1);
                message.deleteCharAt(message.length() - 1);
                message.append(")");
            }
        });
        return message.toString();
    }

    public static String[] split(String value, char delimiter) {
        if (value == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) != delimiter) continue;
            result.add(value.substring(start, i));
            start = i + 1;
        }
        result.add(value.substring(start));
        return result.toArray(new String[result.size()]);
    }

    public static String[] splitParagraphs(String value) {
        String[] lines = StringUtil.split(value, '\n');
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = lines[i].trim();
        }
        ArrayList<String> output = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (String line : lines) {
            if (line.length() == 0) {
                if (current.length() <= 0) continue;
                output.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            current.append(' ').append(line);
        }
        if (current.length() > 0) {
            output.add(current.toString());
        }
        return output.toArray(new String[output.size()]);
    }

    public static String unescapeString(String oldstr) {
        if (oldstr.charAt(0) == '\"' && oldstr.charAt(oldstr.length() - 1) == '\"' || oldstr.charAt(0) != '\'' || oldstr.charAt(oldstr.length() - 1) != '\'') {
            // empty if block
        }
        oldstr = oldstr.substring(1, oldstr.length() - 1);
        StringBuilder newstr = new StringBuilder(oldstr.length());
        boolean saw_backslash = false;
        for (int i = 0; i < oldstr.length(); ++i) {
            int cp = oldstr.codePointAt(i);
            if (oldstr.codePointAt(i) > 65535) {
                ++i;
            }
            if (!saw_backslash) {
                if (cp == 92) {
                    saw_backslash = true;
                    continue;
                }
                newstr.append(Character.toChars(cp));
                continue;
            }
            if (cp == 92) {
                saw_backslash = false;
                newstr.append('\\');
                newstr.append('\\');
                continue;
            }
            switch (cp) {
                case 114: {
                    newstr.append('\r');
                    break;
                }
                case 110: {
                    newstr.append('\n');
                    break;
                }
                case 102: {
                    newstr.append('\f');
                    break;
                }
                case 98: {
                    newstr.append("\\b");
                    break;
                }
                case 116: {
                    newstr.append('\t');
                    break;
                }
                case 97: {
                    newstr.append('\u0007');
                    break;
                }
                case 101: {
                    newstr.append('\u001b');
                    break;
                }
                case 99: {
                    if (++i == oldstr.length()) {
                        // empty if block
                    }
                    if ((cp = oldstr.codePointAt(i)) > 127) {
                        // empty if block
                    }
                    newstr.append(Character.toChars(cp ^ 0x40));
                    break;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    --i;
                }
                case 48: {
                    char ch;
                    int j;
                    if (i + 1 == oldstr.length()) {
                        newstr.append(Character.toChars(0));
                        break;
                    }
                    ++i;
                    int digits = 0;
                    for (j = 0; j <= 2 && i + j != oldstr.length() && (ch = oldstr.charAt(i + j)) >= '0' && ch <= '7'; ++j) {
                        ++digits;
                    }
                    if (digits == 0) {
                        --i;
                        newstr.append('\u0000');
                        break;
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + digits), 8);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    newstr.append(Character.toChars(value));
                    i += digits - 1;
                    break;
                }
                case 120: {
                    int j;
                    if (i + 2 > oldstr.length()) {
                        // empty if block
                    }
                    boolean saw_brace = false;
                    if (oldstr.charAt(++i) == '{') {
                        ++i;
                        saw_brace = true;
                    }
                    for (j = 0; j < 8 && (saw_brace || j != 2); ++j) {
                        char ch = oldstr.charAt(i + j);
                        if (ch > '\u007f') {
                            // empty if block
                        }
                        if (saw_brace && ch == '}') break;
                        if (!(ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch < 'A') && ch <= 'F') continue;
                    }
                    if (j == 0) {
                        // empty if block
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    newstr.append(Character.toChars(value));
                    if (saw_brace) {
                        ++j;
                    }
                    i += j - 1;
                    break;
                }
                case 117: {
                    int j;
                    if (i + 4 > oldstr.length()) {
                        // empty if block
                    }
                    ++i;
                    for (j = 0; j < 4; ++j) {
                        if (oldstr.charAt(i + j) <= '\u007f') continue;
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    newstr.append(Character.toChars(value));
                    i += j - 1;
                    break;
                }
                case 85: {
                    int j;
                    if (i + 8 > oldstr.length()) {
                        // empty if block
                    }
                    ++i;
                    for (j = 0; j < 8; ++j) {
                        if (oldstr.charAt(i + j) <= '\u007f') continue;
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    newstr.append(Character.toChars(value));
                    i += j - 1;
                    break;
                }
                default: {
                    newstr.append('\\');
                    newstr.append(Character.toChars(cp));
                }
            }
            saw_backslash = false;
        }
        if (saw_backslash) {
            newstr.append('\\');
        }
        return newstr.toString();
    }

    private static String uniplus(String s) {
        if (s.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(2 + 3 * s.length());
        sb.append("U+");
        for (int i = 0; i < s.length(); ++i) {
            sb.append(String.format("%X", s.codePointAt(i)));
            if (s.codePointAt(i) > 65535) {
                ++i;
            }
            if (i + 1 >= s.length()) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }
}

