/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IWidgetMouseInput;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WidgetScrollBar
extends WidgetBase
implements IWidgetMouseInput {
    public static final int BAR_WIDTH = 14;
    public int minValue;
    public int maxValue;
    public int scrollValue;
    @SideOnly(value=Side.CLIENT)
    boolean allowGeneralMouseWheel;
    private float drawValue;
    private boolean isScrolling;
    public boolean hideWhenInvalid;

    public WidgetScrollBar(int x, int y, int h, int minValue, int maxValue) {
        super(x, y, 14, h);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.scrollValue = minValue;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void mouseClicked(int mouseX, int mouseY, int mouseButton, boolean mouseOver) {
        if (this.minValue == this.maxValue) {
            return;
        }
        if (mouseOver && mouseButton == 0) {
            this.isScrolling = true;
            this.scroll(mouseY - this.gui.field_147009_r - this.y);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setValues(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        if (minValue == maxValue) {
            this.isScrolling = false;
        }
        this.reScroll();
    }

    @SideOnly(value=Side.CLIENT)
    public void reScroll() {
        this.scrollValue = MathHelper.func_76125_a((int)this.scrollValue, (int)this.minValue, (int)this.maxValue);
        float a = this.scrollValue - this.minValue;
        this.drawValue = MathHelper.func_76131_a((float)(a * ((float)this.h - 7.0f) / (float)(this.maxValue - this.minValue)), (float)0.0f, (float)(this.h - 17));
        this.onChange();
    }

    @SideOnly(value=Side.CLIENT)
    private void scroll(float y) {
        if (y <= 9.0f) {
            this.drawValue = 0.0f;
            this.scrollValue = this.minValue;
        } else if (y > (float)(this.h - 8)) {
            this.drawValue = this.h - 17;
            this.scrollValue = this.maxValue;
        } else {
            this.drawValue = y - 9.0f;
            float a = this.drawValue * (float)(this.maxValue - this.minValue) / (float)(this.h - 7);
            int num = this.minValue + Math.round(a);
            this.scrollValue = MathHelper.func_76125_a((int)num, (int)this.minValue, (int)this.maxValue);
        }
        this.onChange();
    }

    @SideOnly(value=Side.CLIENT)
    protected void onChange() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void mouseReleased(int mouseX, int mouseY, int mouseButton, boolean mouseOver) {
        this.isScrolling = false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void mouseClickMove(int mouseX, int mouseY, int mouseButton, long timeSinceLastMove, boolean mouseOver) {
        if (this.isScrolling) {
            this.scroll(mouseY - this.gui.field_147009_r - this.y);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        if (this.hideWhenInvalid && this.minValue == this.maxValue) {
            return;
        }
        if (this.h == 112) {
            gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 220, 0, 14, 112);
        } else if (this.h < 112) {
            int h2 = this.h / 2;
            gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 220, 0, 14, h2);
            gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY() + this.h - h2 - 1, 220, 112 - h2, 14, h2 + 1);
        } else {
            gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 220, 0, 14, 16);
            int k = 16;
            while (k + 80 < this.h) {
                gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY() + k, 220, 16, 14, 80);
                k += 80;
            }
            gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY() + k, 220, 112 - (this.h - k), 14, this.h - k);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        if (this.hideWhenInvalid && this.minValue == this.maxValue) {
            return;
        }
        gui.func_175174_a(guiLeft + this.getX() + 1, (float)(guiTop + this.getY()) + this.drawValue, 196, 0, 12, 15);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void mouseWheelScroll(int delta, boolean mouseOver) {
        if (!mouseOver && !this.allowGeneralMouseWheel) {
            return;
        }
        if (delta == 0) {
            return;
        }
        if (delta > 0) {
            delta = -1;
        } else if (delta < 0) {
            delta = 1;
        }
        this.setValue(this.scrollValue + delta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void mouseTick(int mouseX, int mouseY, boolean mouseOver) {
    }

    @Override
    public boolean usesMouseWheel() {
        return true;
    }

    public void setValue(int newValue) {
        if (this.scrollValue != (newValue = MathHelper.func_76125_a((int)newValue, (int)this.minValue, (int)this.maxValue))) {
            this.scrollValue = newValue;
            this.reScroll();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addToGui(DynamicGui gui) {
        super.addToGui(gui);
        this.allowGeneralMouseWheel = true;
        for (IWidgetMouseInput input : gui.container.getWidgetMouseInputs()) {
            if (input == this || !input.usesMouseWheel()) continue;
            this.allowGeneralMouseWheel = false;
            break;
        }
    }
}

