/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.mojang.realmsclient.gui.ChatFormatting;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.api.items.IItemFilter;
import com.rwtema.extrautils2.backend.XUItemFlatMetadata;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.CompatHelper112;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonChoices;
import com.rwtema.extrautils2.gui.backend.WidgetSlotGhost;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerBase;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class ItemFilterItems
extends XUItemFlatMetadata
implements IItemFilter,
IDynamicHandler {
    public static final int NUM_SLOTS = 16;
    public static final String NBT_KEY_FLAGS = "Flags";

    public ItemFilterItems() {
        super("filter_item");
    }

    public static boolean getFlag(ItemStack filter, FLAG flag) {
        NBTTagCompound nbt = filter.func_77978_p();
        int i = nbt == null ? 0 : nbt.func_74762_e(NBT_KEY_FLAGS);
        return (i & flag.meta) != 0;
    }

    public static void setFlag(ItemStack filter, FLAG flag, boolean value) {
        if (!value && !filter.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = NBTHelper.getOrInitTagCompound(filter);
        int flags = nbt.func_74762_e(NBT_KEY_FLAGS);
        flags = value ? (flags ^= flag.meta) : (flags &= ~flag.meta);
        if (flags == 0) {
            nbt.func_82580_o(NBT_KEY_FLAGS);
            if (nbt.func_82582_d()) {
                filter.func_77982_d(null);
            }
        } else if (flags == (byte)flags) {
            nbt.func_74774_a(NBT_KEY_FLAGS, (byte)flags);
        } else {
            nbt.func_74768_a(NBT_KEY_FLAGS, (int)((byte)flags));
        }
    }

    public static ItemStack getGhostStack(ItemStack filter, int i) {
        NBTTagCompound nbt = filter.func_77978_p();
        String stringDigit = CollectionHelper.STRING_DIGITS[i];
        if (nbt == null || !nbt.func_150297_b(stringDigit, 10)) {
            return StackHelper.empty();
        }
        return StackHelper.loadFromNBT(nbt.func_74775_l(stringDigit));
    }

    public static void putGhostStack(ItemStack filter, int i, ItemStack result) {
        if (StackHelper.isNull(result) && !filter.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = NBTHelper.getOrInitTagCompound(filter);
        String stringDigit = CollectionHelper.STRING_DIGITS[i];
        if (StackHelper.isNull(result)) {
            nbt.func_82580_o(stringDigit);
            if (nbt.func_82582_d()) {
                filter.func_77982_d(null);
            }
        } else {
            NBTTagCompound nbtTagCompound = result.serializeNBT();
            nbt.func_74782_a(stringDigit, (NBTBase)nbtTagCompound);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return StackHelper.isNull(oldStack) || StackHelper.isNull(newStack) || oldStack.func_77973_b() != this || newStack.func_77973_b() != this;
    }

    @Override
    public boolean isItemFilter(@Nonnull ItemStack filterStack) {
        return true;
    }

    @Override
    public boolean matches(@Nonnull ItemStack filterStack, ItemStack target) {
        if (!filterStack.func_77942_o()) {
            return false;
        }
        boolean inverted = ItemFilterItems.getFlag(filterStack, FLAG.INVERTED);
        if (StackHelper.isNull(target)) {
            return inverted;
        }
        boolean useOreDic = ItemFilterItems.getFlag(filterStack, FLAG.USE_ORE_DICTIONARY);
        boolean useMeta = !ItemFilterItems.getFlag(filterStack, FLAG.IGNORE_METADATA);
        boolean useNBT = !ItemFilterItems.getFlag(filterStack, FLAG.IGNORE_NBT);
        for (int i = 0; i < 16; ++i) {
            IItemFilter filter;
            ItemStack ghostStack = ItemFilterItems.getGhostStack(filterStack, i);
            if (StackHelper.isNull(ghostStack)) continue;
            Item item = ghostStack.func_77973_b();
            if (item instanceof IItemFilter && (filter = (IItemFilter)item).matches(ghostStack, target)) {
                return !inverted;
            }
            if (useOreDic) {
                int[] ghostOreIDs = OreDictionary.getOreIDs((ItemStack)ghostStack);
                int[] targetOreIDs = OreDictionary.getOreIDs((ItemStack)ghostStack);
                for (int a : ghostOreIDs) {
                    for (int b : targetOreIDs) {
                        if (a != b) continue;
                        return !inverted;
                    }
                }
            }
            if (item != target.func_77973_b() || useMeta && ghostStack.func_77960_j() != target.func_77960_j() || useNBT && !ItemStack.func_77970_a((ItemStack)ghostStack, (ItemStack)target)) continue;
            return !inverted;
        }
        return inverted;
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> onItemRightClickBase(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K) {
            this.openItemGui(playerIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        if (player == null) {
            return null;
        }
        InventoryPlayer inventory = player.field_71071_by;
        int slot = inventory.field_70461_c;
        ItemStack heldItem = player.func_184614_ca();
        if (StackHelper.isNull(heldItem) || heldItem.func_77973_b() != this) {
            return null;
        }
        return new FilterConfigContainer(player, slot, heldItem);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            ItemStack ghostStack = ItemFilterItems.getGhostStack(stack, i);
            if (StackHelper.isNull(ghostStack)) continue;
            String resourceName = "" + Item.field_150901_e.func_177774_c((Object)ghostStack.func_77973_b());
            List<String> list = CompatHelper112.getTooltip(ghostStack, playerIn, false);
            for (int j = 0; j < list.size(); ++j) {
                String s = list.get(j);
                String noFormatting = ChatFormatting.stripFormatting((String)s).trim();
                if (noFormatting.isEmpty() || noFormatting.equals(resourceName)) continue;
                if (j == 0) {
                    tooltip.add(ChatFormatting.GRAY + StringHelper.format(1 + i) + " -- " + ChatFormatting.WHITE + s);
                    continue;
                }
                tooltip.add(ChatFormatting.GRAY + "      " + s);
            }
        }
        tooltip.add("");
        for (FLAG flag : FLAG.values()) {
            boolean b = ItemFilterItems.getFlag(stack, flag);
            if (!b) continue;
            tooltip.add(ChatFormatting.BLUE + Lang.translate(flag.name()));
        }
    }

    public class FilterConfigContainer
    extends DynamicContainer {
        private final EntityPlayer player;
        private final int slot;
        WidgetSlotGhost[] ghostSlots = new WidgetSlotGhost[16];

        public FilterConfigContainer(EntityPlayer player, int slot, final ItemStack heldItem) {
            FLAG[] flagValues;
            this.player = player;
            this.slot = slot;
            int NUM_COLUMNS = (int)Math.sqrt(16.0);
            int inner_filter_w = NUM_COLUMNS * 18;
            int filter_w = inner_filter_w * 14 / 8;
            int filter_h_offset = filter_w * 3 / 14 - 5;
            WidgetBase filter_item = new WidgetBase(85 - filter_w / 2, 5, filter_w, filter_w){

                @Override
                public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                    TextureAtlasSprite sprite = Textures.getSprite("filter_item");
                    if (sprite == null) {
                        return;
                    }
                    manager.func_110577_a(TextureMap.field_110575_b);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179112_b((int)770, (int)771);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    gui.drawTexturedModalRect(guiLeft + this.x, guiTop + this.y, this.w, this.h, sprite.func_94214_a(1.0), sprite.func_94207_b(1.0), sprite.func_94214_a(15.0), sprite.func_94207_b(15.0));
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            };
            this.addWidget(filter_item);
            this.addTitle(Lang.getItemName(ItemFilterItems.this), false);
            for (int i = 0; i < 16; ++i) {
                int slotX = i % NUM_COLUMNS;
                int slotY = i / NUM_COLUMNS;
                final int dSlot = i;
                this.ghostSlots[i] = new WidgetSlotGhost(new SingleStackHandlerBase(){

                    @Override
                    @ItemStackNonNull
                    public ItemStack getStack() {
                        return ItemFilterItems.getGhostStack(heldItem, dSlot);
                    }

                    @Override
                    public void setStack(@ItemStackNonNull ItemStack stack) {
                        ItemFilterItems.putGhostStack(heldItem, dSlot, stack);
                    }
                }, dSlot, 85 - NUM_COLUMNS * 9 + slotX * 18, 10 + filter_h_offset + slotY * 18);
                this.addWidget(this.ghostSlots[i]);
            }
            this.crop();
            for (final FLAG flag : flagValues = FLAG.values()) {
                int i = flag.ordinal();
                int dx = i % 2;
                int dy = i / 2;
                int x = 5 + dx * 162 / 2;
                if (dx == 0) {
                    x = 5;
                } else {
                    int w = 8 + Math.max(ExtraUtils2.proxy.apply(DynamicContainer.STRING_WIDTH_FUNCTION, Lang.translate(flag.OFF_KEY)), ExtraUtils2.proxy.apply(DynamicContainer.STRING_WIDTH_FUNCTION, Lang.translate(flag.ON_KEY)));
                    x = 162 - w;
                }
                int y = 10 + filter_h_offset + NUM_COLUMNS * 18 + 4 + dy * 18;
                this.addWidget((IWidget)((WidgetClickMCButtonChoices)new WidgetClickMCButtonChoices<Boolean>(x, y){

                    @Override
                    protected void onSelectedServer(Boolean marker) {
                        ItemFilterItems.setFlag(heldItem, flag, marker);
                    }

                    @Override
                    public Boolean getSelectedValue() {
                        return ItemFilterItems.getFlag(heldItem, flag);
                    }
                }.addChoice(Boolean.valueOf(false), Lang.translate(flag.OFF_KEY), flag.OFF_KEY)).addChoice((Boolean)true, Lang.translate(flag.ON_KEY), flag.ON_KEY));
            }
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }

        public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
            ItemStack heldItem;
            return playerIn == this.player && this.player.field_71071_by.field_70461_c == this.slot && StackHelper.isNonNull(heldItem = playerIn.func_184614_ca()) && heldItem.func_77973_b() == ItemFilterItems.this;
        }

        @Override
        @ItemStackNonNull
        public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
            Slot slot = (Slot)this.field_75151_b.get(par2);
            if (slot instanceof WidgetSlotGhost) {
                slot.func_75215_d(StackHelper.empty());
            } else {
                ItemStack slotStack = slot.func_75211_c();
                if (StackHelper.isNonNull(slotStack)) {
                    ItemStack stack;
                    for (WidgetSlotGhost ghostSlot : this.ghostSlots) {
                        stack = ghostSlot.func_75211_c();
                        if (!StackHelper.isNonNull(stack) || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)slotStack)) continue;
                        return StackHelper.empty();
                    }
                    for (WidgetSlotGhost ghostSlot : this.ghostSlots) {
                        stack = ghostSlot.func_75211_c();
                        if (!StackHelper.isNull(stack)) continue;
                        ghostSlot.func_75215_d(slotStack.func_77946_l());
                        break;
                    }
                }
            }
            return StackHelper.empty();
        }
    }

    static enum FLAG {
        INVERTED,
        IGNORE_NBT,
        IGNORE_METADATA,
        USE_ORE_DICTIONARY;

        public final int meta = 1 << this.ordinal();
        public final String ON_KEY = this.name() + " ON";
        public final String OFF_KEY = this.name() + " OFF";
    }
}

