/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.modcompat;

import com.rwtema.extrautils2.modcompat.XUTConTextureBase;
import com.rwtema.extrautils2.utils.datastructures.IntPair;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class XUTConTextureMagicWood
extends XUTConTextureBase {
    static int[][] offsets = new int[][]{{0, 1}, {1, 1}, {1, 0}, {1, -1}, {0, -1}, {-1, -1}, {-1, 0}, {-1, 1}};

    protected XUTConTextureMagicWood(ResourceLocation baseTexture, String spriteName) {
        super(baseTexture, spriteName);
    }

    protected XUTConTextureMagicWood(String baseTextureLocation, String spriteName) {
        super(baseTextureLocation, spriteName);
    }

    private boolean[][] orwise(boolean[][] a, boolean[][] b) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                boolean[] blArray = a[i];
                int n = j;
                blArray[n] = blArray[n] | b[i][j];
            }
        }
        return a;
    }

    private boolean[][] mult(boolean[][] a, boolean[][] b) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                boolean[] blArray = a[i];
                int n = j;
                blArray[n] = blArray[n] & b[i][j];
            }
        }
        return a;
    }

    private boolean[][] multI(boolean[][] a, boolean[][] b) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                boolean[] blArray = a[i];
                int n = j;
                blArray[n] = blArray[n] & !b[i][j];
            }
        }
        return a;
    }

    private boolean[][] expand(boolean[][] base, int n) {
        boolean[][] output = this.expand(base);
        for (int i = 0; i < n - 1; ++i) {
            output = this.expand(output);
        }
        return output;
    }

    private boolean[][] contract(boolean[][] base, int n) {
        boolean[][] output = this.contract(base);
        for (int i = 0; i < n - 1; ++i) {
            output = this.contract(output);
        }
        return output;
    }

    @Override
    protected void preProcess(int[] datum, Map<IntPair, Integer> valueOverride, Map<IntPair, Integer> colorOverride) {
        int w = this.field_130223_c;
        int h = this.field_130224_d;
        int[][] pixels = new int[w][h];
        boolean[][] base = new boolean[w][h];
        int mean = 0;
        int div = 0;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                boolean nottrans;
                int c = datum[this.coord(x, y)];
                pixels[x][y] = ColorHelper.brightness(c);
                boolean bl = nottrans = c != 0 && ColorHelper.getA(c) > 64;
                if (!nottrans) continue;
                base[x][y] = true;
                mean += pixels[x][y];
                ++div;
            }
        }
        mean = mean / div * 2 / 4;
        int n = w >= 256 ? 5 : (w >= 128 ? 4 : (w >= 64 ? 3 : (w >= 32 ? 2 : 1)));
        boolean[][] baseSilhouette = this.contract(base, n);
        boolean[][] interior1 = this.contract(baseSilhouette, n);
        boolean[][] baseCorners = this.multI(this.mult(this.expand(this.getCorners(baseSilhouette), n), baseSilhouette), interior1);
        boolean[][] baseCornersShift = this.orwise(this.orwise(this.shift(baseCorners, 0, -1), this.shift(baseCorners, -1, 0)), this.shift(baseCorners, -1, -1));
        boolean[][] interior2 = this.contract(interior1, 2 * n);
        boolean[][] interior3 = this.contract(interior2, n);
        boolean[][] interior4 = this.contract(interior3, n);
        boolean[][] interiorCorners = this.multI(this.mult(this.expand(this.getCorners(interior2), n), interior2), interior3);
        boolean[][] interiorCornersShift = this.orwise(this.orwise(this.shift(interiorCorners, -1, 0), this.shift(interiorCorners, 0, -1)), this.shift(interiorCorners, -1, -1));
        int trans = 0;
        int gold = -398001;
        int gold_highlight = -117;
        int wood = -6455217;
        int darkwood = -10071758;
        int[][] outpixels = new int[w][h];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                outpixels[x][y] = !baseSilhouette[x][y] ? (base[x][y] ? XUTConTextureMagicWood.multPixel(darkwood, pixels[x][y] / 2) : trans) : (!interior1[x][y] ? (baseCorners[x][y] ? (baseCornersShift[x][y] ? XUTConTextureMagicWood.multPixel(gold, Math.max(pixels[x][y], mean)) : XUTConTextureMagicWood.multPixel(gold_highlight, Math.max(pixels[x][y], mean) + 5)) : XUTConTextureMagicWood.multPixel(darkwood, pixels[x][y])) : (!interior2[x][y] || interior3[x][y] ? (interior3[x][y] && !interior4[x][y] ? XUTConTextureMagicWood.multPixel(wood, pixels[x][y] * 3 / 4) : XUTConTextureMagicWood.multPixel(wood, pixels[x][y])) : (interiorCorners[x][y] ? (interiorCornersShift[x][y] ? XUTConTextureMagicWood.multPixel(gold, Math.max(pixels[x][y], mean)) : XUTConTextureMagicWood.multPixel(gold_highlight, Math.max(pixels[x][y], mean) + 5)) : XUTConTextureMagicWood.multPixel(darkwood, pixels[x][y]))));
                valueOverride.put(IntPair.of(x, y), outpixels[x][y]);
            }
        }
    }

    private int clamp(int i) {
        return MathHelper.func_76125_a((int)i, (int)0, (int)255);
    }

    public boolean get(boolean[][] img, int x, int y) {
        return x >= 0 && y >= 0 && x < img.length && y < img[x].length && img[x][y];
    }

    public boolean[][] shift(boolean[][] img, int dx, int dy) {
        int w = img.length;
        boolean[][] img2 = new boolean[w][w];
        for (int x = Math.max(-dx, 0); x < Math.min(w, w + dx); ++x) {
            System.arraycopy(img[x + dx], Math.max(-dy, 0) + dy, img2[x], Math.max(-dy, 0), Math.min(w, w + dy) - Math.max(-dy, 0));
        }
        return img2;
    }

    public boolean[][] getCorners(boolean[][] img) {
        int w = img.length;
        boolean[][] img2 = new boolean[w][w];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < w; ++y) {
                if (!img[x][y]) continue;
                int an = -1;
                int n = 0;
                for (int[] offset : offsets) {
                    if (this.get(img, x + offset[0], y + offset[1])) {
                        if (an == -1) {
                            an = n;
                        }
                        n = 0;
                        continue;
                    }
                    if (++n == 5) break;
                }
                if (an != -1) {
                    n += an;
                }
                if (n < 5) continue;
                img2[x][y] = true;
            }
        }
        return img2;
    }

    public boolean[][] contract(boolean[][] img) {
        int x;
        int w = img.length;
        boolean[][] img2 = new boolean[w][w];
        for (x = 0; x < w; ++x) {
            System.arraycopy(img[x], 0, img2[x], 0, w);
        }
        for (x = 0; x < w; ++x) {
            for (int y = 0; y < w; ++y) {
                if (img[x][y]) {
                    if (x != 0 && y != 0 && x != w - 1 && y != w - 1) continue;
                    img2[x][y] = false;
                    continue;
                }
                if (x > 0) {
                    img2[x - 1][y] = false;
                }
                if (y > 0) {
                    img2[x][y - 1] = false;
                }
                if (x < w - 1) {
                    img2[x + 1][y] = false;
                }
                if (y >= w - 1) continue;
                img2[x][y + 1] = false;
            }
        }
        return img2;
    }

    public boolean[][] expand(boolean[][] img) {
        int x;
        int w = img.length;
        boolean[][] img2 = new boolean[w][w];
        for (x = 0; x < w; ++x) {
            System.arraycopy(img[x], 0, img2[x], 0, w);
        }
        for (x = 0; x < w; ++x) {
            for (int y = 0; y < w; ++y) {
                if (!img[x][y]) continue;
                for (int[] offset : offsets) {
                    int dx = x + offset[0];
                    int dy = y + offset[1];
                    if (dx < 0 || dy < 0 || dx >= w || dy >= w) continue;
                    img2[dx][dy] = true;
                }
            }
        }
        return img2;
    }
}

