/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power.player;

import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.power.player.IPlayerPowerCreator;
import com.rwtema.extrautils2.power.player.PlayerPower;
import com.rwtema.extrautils2.utils.datastructures.ID;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.Pair;

public class PlayerPowerManager {
    static HashMap<Pair<ID<EntityPlayer>, IPlayerPowerCreator>, PlayerPower> powerServer = new HashMap();
    public static final Function<EntityPlayer, Stream<ItemStack>> getStacks = p -> IntStream.range(0, p.field_71071_by.func_70302_i_()).mapToObj(i -> p.field_71071_by.func_70301_a(i)).filter(StackHelper::isNonNull);

    public static void clear() {
        powerServer.clear();
    }

    @Nullable
    public static <T extends Item> PlayerPower get(EntityPlayer player, T item) {
        return powerServer.get(Pair.of(new ID<EntityPlayer>(player), item));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        HashSet players = new HashSet(FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v());
        HashSet<PlayerPower> loadedPowers = new HashSet<PlayerPower>();
        HashSet<PlayerPower> addedPowers = new HashSet<PlayerPower>();
        for (EntityPlayer player : players) {
            for (ItemStack stack : () -> getStacks.apply(player).iterator()) {
                if (!StackHelper.isNonNull(stack) || !(stack.func_77973_b() instanceof IPlayerPowerCreator)) continue;
                IPlayerPowerCreator creator = (IPlayerPowerCreator)stack.func_77973_b();
                Pair key = Pair.of(new ID<EntityPlayer>(player), (Object)creator);
                PlayerPower playerPower = powerServer.get(key);
                if (playerPower == null || creator.shouldOverride(playerPower, player, stack, stack == player.field_71071_by.func_70448_g())) {
                    if (playerPower != null) {
                        playerPower.onRemove();
                    }
                    if ((playerPower = creator.createPower(player, stack)) == null) continue;
                    powerServer.put((Pair<ID<EntityPlayer>, IPlayerPowerCreator>)key, playerPower);
                    addedPowers.add(playerPower);
                } else if (!playerPower.shouldSustain(stack)) continue;
                playerPower.update(player.field_71071_by.func_70448_g() == stack, stack);
                playerPower.cooldown = 20;
                loadedPowers.add(playerPower);
            }
        }
        Iterator<Map.Entry<Pair<ID<EntityPlayer>, IPlayerPowerCreator>, PlayerPower>> iterator = powerServer.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean expired;
            Map.Entry<Pair<ID<EntityPlayer>, IPlayerPowerCreator>, PlayerPower> entry2 = iterator.next();
            EntityPlayer player = (EntityPlayer)((ID)entry2.getKey().getLeft()).object;
            PlayerPower power = entry2.getValue();
            boolean playerIsLoaded = !players.contains(player);
            boolean incorrectDimension = player.field_70170_p.field_73011_w.getDimension() != power.dimension;
            boolean bl = expired = !loadedPowers.contains(power);
            if (playerIsLoaded || incorrectDimension || expired) {
                this.removePlayer(power);
                iterator.remove();
                continue;
            }
            if (addedPowers.contains(power)) continue;
            power.tick();
        }
        for (PlayerPower playerPower : addedPowers) {
            playerPower.onAdd();
            PowerManager.instance.addPowerHandler(playerPower);
        }
    }

    public void removePlayer(PlayerPower power) {
        power.invalid = true;
        power.onRemove();
        PowerManager.instance.removePowerHandler(power);
    }
}

