/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonChoices;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerFilter;
import com.rwtema.extrautils2.transfernodes.Grocket;
import com.rwtema.extrautils2.transfernodes.GrocketType;
import com.rwtema.extrautils2.transfernodes.IBuffer;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class GrocketPipeFilter
extends Grocket
implements IDynamicHandler {
    public SingleStackHandlerFilter.EitherFilter filter = this.registerNBT("filter", new SingleStackHandlerFilter.EitherFilter());
    public NBTSerializable.NBTEnum<Priority> priority = this.registerNBT("priority", new NBTSerializable.NBTEnum<Priority>(Priority.HIGH));

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new TransferPipeContainer(player);
    }

    @Override
    public GrocketType getType() {
        return GrocketType.FILTER_PIPE;
    }

    @Override
    public float getPower() {
        return 0.0f;
    }

    @Override
    public boolean shouldBlock(IBuffer buffer) {
        return !this.filter.matches(buffer);
    }

    @Override
    public boolean blockPipeConnection() {
        return false;
    }

    @Override
    public boolean blockTileConnection() {
        return true;
    }

    @Override
    public Priority getPriority() {
        return (Priority)((Object)this.priority.value);
    }

    public class TransferPipeContainer
    extends DynamicContainerTile {
        public TransferPipeContainer(EntityPlayer player) {
            super(GrocketPipeFilter.this.holder);
            this.addTitle("Transfer Filter");
            this.crop();
            this.addWidget(GrocketPipeFilter.this.filter.newSlot(4, this.height + 4));
            this.addWidget((IWidget)((WidgetClickMCButtonChoices)((WidgetClickMCButtonChoices)new WidgetClickMCButtonChoices<Priority>(26, this.height + 4){

                @Override
                protected void onSelectedServer(Priority marker) {
                    GrocketPipeFilter.this.priority.value = marker;
                    GrocketPipeFilter.this.markDirty();
                }

                @Override
                public Priority getSelectedValue() {
                    return (Priority)((Object)GrocketPipeFilter.this.priority.value);
                }
            }.addChoice(Priority.HIGH, "High Priority", null)).addChoice((Priority)Priority.NORMAL, "Neutral Priority", null)).addChoice((Priority)Priority.LOW, "Low Priority", null));
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }

    static enum Priority {
        HIGH,
        NORMAL,
        LOW;

    }
}

