/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.transfernodes.IPipeConnect;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;

public class CapGetter<T> {
    public static CapGetter<IItemHandler> ItemHandler = new CapGetter<IItemHandler>(IItemHandler.class, new Converter[0]);
    public static CapGetter<IPipeConnect> PipeConnect = new CapGetter<IPipeConnect>(IPipeConnect.class, new Converter[0]){

        @Override
        public boolean hasInterface(ICapabilityProvider provider, EnumFacing side) {
            return provider instanceof IPipeConnect && ((IPipeConnect)provider).forceConnect(side);
        }

        @Override
        public IPipeConnect getInterface(ICapabilityProvider provider, EnumFacing side) {
            return null;
        }
    };
    public static CapGetter<IFluidHandler> FluidHandler = new CapGetter<IFluidHandler>(IFluidHandler.class, new Converter[0]);
    public static ArrayList<CapGetter<?>> caps = Lists.newArrayList((Object[])new CapGetter[]{ItemHandler, PipeConnect, FluidHandler});
    private static IdentityHashMap<String, Capability<?>> providers = (IdentityHashMap)ObfuscationReflectionHelper.getPrivateValue(CapabilityManager.class, (Object)CapabilityManager.INSTANCE, (String[])new String[]{"providers"});
    public static CapGetter<IEnergyStorage> energyReceiver = new CapGetter<IEnergyStorage>(IEnergyStorage.class, new Converter[0]){

        @Override
        protected boolean hasCapability(ICapabilityProvider provider, EnumFacing side) {
            if (!provider.hasCapability(this.capability, side)) {
                return false;
            }
            IEnergyStorage capability = (IEnergyStorage)provider.getCapability(this.capability, side);
            return capability != null && capability.canReceive();
        }

        @Override
        public IEnergyStorage getInterface(ICapabilityProvider provider, EnumFacing side) {
            IEnergyStorage anInterface = (IEnergyStorage)super.getInterface(provider, side);
            return anInterface != null && anInterface.canReceive() ? anInterface : null;
        }
    };
    public static CapGetter<IEnergyStorage> energyExtractor = new CapGetter<IEnergyStorage>(IEnergyStorage.class, new Converter[0]){

        @Override
        protected boolean hasCapability(ICapabilityProvider provider, EnumFacing side) {
            if (!provider.hasCapability(this.capability, side)) {
                return false;
            }
            IEnergyStorage capability = (IEnergyStorage)provider.getCapability(this.capability, side);
            return capability != null && capability.canExtract();
        }

        @Override
        public IEnergyStorage getInterface(ICapabilityProvider provider, EnumFacing side) {
            IEnergyStorage anInterface = (IEnergyStorage)super.getInterface(provider, side);
            return anInterface != null && anInterface.canReceive() ? anInterface : null;
        }
    };
    final Class<T> clazz;
    final Converter<?, T>[] converters;
    boolean init;
    Capability<T> capability;

    @SafeVarargs
    public CapGetter(Class<T> clazz, Converter<?, T> ... converters) {
        this.clazz = clazz;
        this.converters = converters;
    }

    static <T> Capability<T> getCapability(Class<T> clazz) {
        String intern = clazz.getName().intern();
        return providers.get(intern);
    }

    public <R> R cast(T instance) {
        return (R)this.capability.cast(instance);
    }

    public boolean hasInterface(ICapabilityProvider provider, EnumFacing side) {
        if (!this.init) {
            this.capability = CapGetter.getCapability(this.clazz);
            boolean bl = this.init = this.capability != null || Loader.instance().hasReachedState(LoaderState.AVAILABLE);
        }
        if (provider == null) {
            return false;
        }
        if (this.capability != null && this.hasCapability(provider, side)) {
            return true;
        }
        if (this.clazz.isInstance(provider)) {
            return true;
        }
        for (Converter<?, T> converter : this.converters) {
            if (!converter.canHandle(provider, side)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasCapability(ICapabilityProvider provider, EnumFacing side) {
        return provider.hasCapability(this.capability, side);
    }

    public T getInterface(ICapabilityProvider provider, EnumFacing side) {
        if (!this.init) {
            this.capability = CapGetter.getCapability(this.clazz);
            boolean bl = this.init = this.capability != null || Loader.instance().hasReachedState(LoaderState.AVAILABLE);
        }
        if (provider == null) {
            return null;
        }
        if (this.capability != null && this.hasCapability(provider, side)) {
            return (T)provider.getCapability(this.capability, side);
        }
        if (this.clazz.isInstance(provider)) {
            return (T)provider;
        }
        for (Converter<?, T> converter : this.converters) {
            T convert = converter.convert(provider, side);
            if (convert == null) continue;
            return convert;
        }
        return null;
    }

    public static abstract class Converter<S, T> {
        final Class<S> toConvert;

        protected Converter(Class<S> toConvert) {
            this.toConvert = toConvert;
        }

        public T convert(Object type, EnumFacing side) {
            return this.canHandle(type, side) ? (T)this.convertInstance(type, side) : null;
        }

        public boolean canHandle(Object type, EnumFacing side) {
            return this.toConvert.isInstance(type);
        }

        protected abstract T convertInstance(S var1, EnumFacing var2);
    }
}

