/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.helpers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.utils.XURandom;
import com.rwtema.extrautils2.utils.datastructures.FunctionABBool;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.iterator.TObjectFloatIterator;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.list.array.TCharArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.strategy.HashingStrategy;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class CollectionHelper {
    public static final char[] CHAR_DIGITS;
    public static final String[] STRING_DIGITS;
    public static HashingStrategy<ItemStack> HASHING_STRATEGY_ITEMSTACK_ITEM;
    public static HashingStrategy<ItemStack> HASHING_STRATEGY_ITEMSTACK;

    public static <K, V> HashMap<K, V> newHashMap(Object ... objects) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            map.put(objects[i], objects[i + 1]);
        }
        return map;
    }

    public static <K, V> ImmutableMap<K, V> newConstMap(Object ... objects) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < objects.length; i += 2) {
            builder.put(objects[i], objects[i + 1]);
        }
        return builder.build();
    }

    public static <T> Iterable<T> removeNulls(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<T> iterator;
                    T next;
                    {
                        this.iterator = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.next == null) {
                            if (!this.iterator.hasNext()) {
                                return false;
                            }
                            this.next = this.iterator.next();
                        }
                        return true;
                    }

                    @Override
                    public T next() {
                        return this.next;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public static <K, V, T extends Map<K, V>> T populateMap(T map, Object ... objects) {
        for (int i = 0; i < objects.length; i += 2) {
            map.put((Object)objects[i], (Object)objects[i + 1]);
        }
        return map;
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> populateEnumMap(Class<K> clazz, Function<K, V> function) {
        EnumMap<Enum, V> map = new EnumMap<Enum, V>(clazz);
        for (Enum k : (Enum[])clazz.getEnumConstants()) {
            map.put(k, function.apply(k));
        }
        return map;
    }

    public static <K extends Enum<K>> EnumMap<K, EnumSet<K>> populateEnumMultiMap(Class<K> clazz, FunctionABBool<K, K> function) {
        EnumMap<Enum, EnumSet<K>> map = new EnumMap<Enum, EnumSet<K>>(clazz);
        for (Enum input : (Enum[])clazz.getEnumConstants()) {
            EnumSet<K> set = EnumSet.noneOf(clazz);
            for (Enum k2 : (Enum[])clazz.getEnumConstants()) {
                if (!function.apply(input, k2)) continue;
                set.add(k2);
            }
            map.put(input, set);
        }
        return map;
    }

    public static <K> K getRandomElementArray(K[] ks) {
        int i = XURandom.rand.nextInt(ks.length);
        return ks[i];
    }

    @SafeVarargs
    public static <K> K getRandomElementMulti(K a, K ... ks) {
        int i = XURandom.rand.nextInt(ks.length + 1);
        if (i == 0) {
            return a;
        }
        return ks[i - 1];
    }

    public static <K> K getRandomElement(Iterable<K> iterable) {
        return CollectionHelper.getRandomElement(iterable, XURandom.rand);
    }

    public static <K> K getRandomElement(Iterable<K> iterable, Random rand) {
        K r = null;
        int t = 0;
        for (K k : iterable) {
            if (++t != 1 && rand.nextInt(t) != 0) continue;
            r = k;
        }
        return r;
    }

    public static <T> Iterable<ObjectFloatEntry<T>> iterateTOF(final TObjectFloatMap<T> v) {
        return () -> new Iterator<ObjectFloatEntry<T>>(){
            final TObjectFloatIterator iterator;
            ObjectFloatEntry entry;
            {
                this.iterator = v.iterator();
                this.entry = new ObjectFloatEntry<T>(){

                    @Override
                    public T getKey() {
                        return iterator.key();
                    }

                    @Override
                    public float getValue() {
                        return iterator.value();
                    }
                };
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ObjectFloatEntry<T> next() {
                this.iterator.advance();
                return this.entry;
            }
        };
    }

    public static <T> Iterable<ObjectIntEntry<T>> iterateTIO(final TIntObjectMap<T> v) {
        return () -> new Iterator<ObjectIntEntry<T>>(){
            final TIntObjectIterator iterator;
            ObjectIntEntry entry;
            {
                this.iterator = v.iterator();
                this.entry = new ObjectIntEntry<T>(){

                    @Override
                    public T getObject() {
                        return iterator.value();
                    }

                    @Override
                    public int getInt() {
                        return iterator.key();
                    }
                };
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ObjectIntEntry<T> next() {
                this.iterator.advance();
                return this.entry;
            }
        };
    }

    public static <T> Iterable<ObjectIntEntry<T>> iterateTOI(final TObjectIntMap<T> v) {
        return () -> new Iterator<ObjectIntEntry<T>>(){
            final TObjectIntIterator iterator;
            ObjectIntEntry entry;
            {
                this.iterator = v.iterator();
                this.entry = new ObjectIntEntry<T>(){

                    @Override
                    public T getObject() {
                        return iterator.key();
                    }

                    @Override
                    public int getInt() {
                        return iterator.value();
                    }
                };
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ObjectIntEntry<T> next() {
                this.iterator.advance();
                return this.entry;
            }
        };
    }

    public static <T> Iterable<T> wrapConcurrentErrorReport(Iterable<T> iterable) {
        final Iterator<T> iterator = iterable.iterator();
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    T curValue;
                    @Nullable
                    T prevValue;

                    @Override
                    public boolean hasNext() {
                        try {
                            return iterator.hasNext();
                        }
                        catch (ConcurrentModificationException err) {
                            if (this.prevValue == null) {
                                throw err;
                            }
                            throw new ConcurrentModificationException("Comodification error\n Last returned value:" + this.prevValue + (this.prevValue != null ? " (" + this.prevValue.getClass() + ")" : ""), err);
                        }
                    }

                    @Override
                    public T next() {
                        try {
                            this.curValue = iterator.next();
                        }
                        catch (ConcurrentModificationException err) {
                            if (this.prevValue == null) {
                                throw err;
                            }
                            throw new ConcurrentModificationException("Comodification error\n Last returned value:" + this.prevValue + (this.prevValue != null ? " (" + this.prevValue.getClass() + ")" : ""), err);
                        }
                        return this.curValue;
                    }
                };
            }
        };
    }

    public static <T> void performConcurrentErrorReporting(Iterable<T> iterable, Consumer<T> consumer) {
        Iterator<T> iterator = iterable.iterator();
        Object prevValue = null;
        while (iterator.hasNext()) {
            T curValue;
            try {
                curValue = iterator.next();
            }
            catch (ConcurrentModificationException err) {
                if (prevValue == null) {
                    throw err;
                }
                throw new ConcurrentModificationException("Comodification error\n Last returned value:" + prevValue + " (" + prevValue.getClass() + ")", err);
            }
            prevValue = curValue;
            consumer.accept(curValue);
        }
    }

    public static <K, V> Map<K, V> createMap(Collection<K> collection, Function<K, V> function) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (K k : collection) {
            V apply = function.apply(k);
            if (apply == null) continue;
            builder.put(k, apply);
        }
        return builder.build();
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> createMap(Class<K> enumClazz, Function<K, V> function) {
        EnumMap<Enum, V> map = new EnumMap<Enum, V>(enumClazz);
        for (Enum k : (Enum[])enumClazz.getEnumConstants()) {
            V v = function.apply(k);
            if (v == null) continue;
            map.put(k, v);
        }
        return map;
    }

    @SafeVarargs
    public static <T> ImmutableList<Pair<T, T>> splitInputListofPairs(T ... inputs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < inputs.length; i += 2) {
            builder.add((Object)Pair.of(inputs[i], inputs[i + 1]));
        }
        return builder.build();
    }

    public static <T> Pair<ImmutableList<T>, ImmutableList<T>> splitInputPairsofList(T[] inputs) {
        ImmutableList.Builder builder_a = ImmutableList.builder();
        ImmutableList.Builder builder_b = ImmutableList.builder();
        for (int i = 0; i < inputs.length; i += 2) {
            builder_a.add(inputs[i]);
            builder_b.add(inputs[i + 1]);
        }
        return Pair.of((Object)builder_a.build(), (Object)builder_b.build());
    }

    static {
        int i;
        HASHING_STRATEGY_ITEMSTACK_ITEM = new HashingStrategy<ItemStack>(){

            public int computeHashCode(ItemStack object) {
                if (StackHelper.isNull(object) || object.func_77973_b() == null) {
                    return 0;
                }
                return object.func_77973_b().hashCode();
            }

            public boolean equals(ItemStack o1, ItemStack o2) {
                return o1 == o2 || StackHelper.isNonNull(o1) && StackHelper.isNonNull(o2) && o1.func_77973_b() == o2.func_77973_b();
            }
        };
        HASHING_STRATEGY_ITEMSTACK = new HashingStrategy<ItemStack>(){

            public int computeHashCode(ItemStack object) {
                if (StackHelper.isNull(object) || object.func_77973_b() == null) {
                    return 0;
                }
                return object.func_77973_b().hashCode() * 31 + object.func_77952_i();
            }

            public boolean equals(ItemStack o1, ItemStack o2) {
                return o1 == o2 || StackHelper.isNonNull(o1) && StackHelper.isNonNull(o2) && o1.func_77973_b() == o2.func_77973_b() && o1.func_77952_i() == o2.func_77952_i();
            }
        };
        TCharArrayList chars = new TCharArrayList(62);
        for (i = 0; i < 10; ++i) {
            chars.add((char)(48 + i));
        }
        for (i = 0; i < 26; ++i) {
            chars.add((char)(97 + i));
        }
        for (i = 0; i < 26; ++i) {
            chars.add((char)(65 + i));
        }
        chars.addAll(new char[]{'_', '-', '=', '+', '%', '@', '!', '?', '*', '^', '$', '&', '#', '~', ':', ';'});
        CHAR_DIGITS = chars.toArray();
        STRING_DIGITS = new String[CHAR_DIGITS.length];
        for (i = 0; i < STRING_DIGITS.length; ++i) {
            CollectionHelper.STRING_DIGITS[i] = String.valueOf(CHAR_DIGITS[i]);
        }
    }

    public static interface ObjectIntEntry<T> {
        public T getObject();

        public int getInt();

        default public ObjectIntEntry<T> toImmutable() {
            final T key = this.getObject();
            final int value = this.getInt();
            return new ObjectIntEntry<T>(){

                @Override
                public T getObject() {
                    return key;
                }

                @Override
                public int getInt() {
                    return value;
                }
            };
        }
    }

    public static interface ObjectFloatEntry<T> {
        public T getKey();

        public float getValue();

        default public ObjectFloatEntry<T> toImmutable() {
            final T key = this.getKey();
            final float value = this.getValue();
            return new ObjectFloatEntry<T>(){

                @Override
                public T getKey() {
                    return key;
                }

                @Override
                public float getValue() {
                    return value;
                }
            };
        }
    }
}

