/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.library.tank;

import knightminer.ceramics.network.CeramicsNetwork;
import knightminer.ceramics.network.FluidUpdatePacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileTank<T extends TileEntity>
extends FluidTank {
    protected T parent;

    public TileTank(int capacity, T parent) {
        super(capacity);
        this.parent = parent;
    }

    public int fillInternal(FluidStack resource, boolean doFill) {
        int amount = super.fillInternal(resource, doFill);
        if (amount > 0 && doFill) {
            this.sendUpdate(amount);
        }
        return amount;
    }

    public FluidStack drainInternal(int maxDrain, boolean doDrain) {
        FluidStack fluid = super.drainInternal(maxDrain, doDrain);
        if (fluid != null && doDrain) {
            this.sendUpdate(-fluid.amount);
        }
        return fluid;
    }

    protected void sendUpdate(int amount) {
        if (amount != 0) {
            World world = this.parent.func_145831_w();
            if (!world.field_72995_K) {
                CeramicsNetwork.sendToAllAround(world, this.parent.func_174877_v(), new FluidUpdatePacket(this.parent.func_174877_v(), this.getFluid()));
            }
        }
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.fluid != null && this.fluid.amount > capacity) {
            this.drain(this.fluid.amount - capacity, true);
        }
    }
}

