/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mcjty.lib.McJtyRegister;
import mcjty.lib.api.smartwrench.SmartWrench;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.base.ModBase;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.WrenchChecker;
import mcjty.rftools.ModSounds;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.blockprotector.BlockProtectorConfiguration;
import mcjty.rftools.blocks.blockprotector.BlockProtectors;
import mcjty.rftools.blocks.endergen.EndergenicTileEntity;
import mcjty.rftools.blocks.environmental.NoTeleportAreaManager;
import mcjty.rftools.blocks.environmental.PeacefulAreaManager;
import mcjty.rftools.blocks.screens.ScreenBlock;
import mcjty.rftools.blocks.screens.ScreenHitBlock;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.items.smartwrench.SmartWrenchItem;
import mcjty.rftools.playerprops.BuffProperties;
import mcjty.rftools.playerprops.FavoriteDestinationsProperties;
import mcjty.rftools.playerprops.PlayerExtendedProperties;
import mcjty.rftools.playerprops.PropertiesDispatcher;
import mcjty.rftools.shapes.ShapeDataManagerServer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeEventHandlers {
    private static List<Pair<TeleportDestination, EntityPlayer>> playersToTeleportHere = new ArrayList<Pair<TeleportDestination, EntityPlayer>>();

    public static void addPlayerToTeleportHere(TeleportDestination destination, EntityPlayer player) {
        playersToTeleportHere.add((Pair<TeleportDestination, EntityPlayer>)Pair.of((Object)destination, (Object)player));
    }

    private static void performDelayedTeleports() {
        if (!playersToTeleportHere.isEmpty()) {
            for (Pair<TeleportDestination, EntityPlayer> pair : playersToTeleportHere) {
                TeleportationTools.performTeleport((EntityPlayer)pair.getRight(), (TeleportDestination)pair.getLeft(), 0, 10, false);
            }
            playersToTeleportHere.clear();
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        McJtyRegister.registerBlocks((ModBase)RFTools.instance, (IForgeRegistry)event.getRegistry());
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        McJtyRegister.registerItems((ModBase)RFTools.instance, (IForgeRegistry)event.getRegistry());
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> sounds) {
        ModSounds.init((IForgeRegistry<SoundEvent>)sounds.getRegistry());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.world.field_73011_w.getDimension() == 0) {
            ForgeEventHandlers.performDelayedTeleports();
            ShapeDataManagerServer.handleWork();
        }
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        BuffProperties buffProperties;
        if (event.phase == TickEvent.Phase.START && !event.player.func_130014_f_().field_72995_K && (buffProperties = PlayerExtendedProperties.getBuffProperties(event.player)) != null) {
            buffProperties.tickBuffs((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer && !((Entity)event.getObject()).hasCapability(PlayerExtendedProperties.BUFF_CAPABILITY, null)) {
            event.addCapability(new ResourceLocation("rftools", "Properties"), (ICapabilityProvider)new PropertiesDispatcher());
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        double blockReachDistance;
        RayTraceResult rayTrace;
        if (event.getWorld().field_72995_K) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack heldItem = player.func_184614_ca();
        if ((heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof SmartWrench)) && (rayTrace = ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)((blockReachDistance = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance()) + 1.0))) != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            Block block = event.getWorld().func_180495_p(rayTrace.func_178782_a()).func_177230_c();
            if (block instanceof ScreenBlock) {
                event.setCanceled(true);
                return;
            }
            if (block instanceof ScreenHitBlock) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        World world;
        ItemStack heldItem;
        EntityPlayer player = event.getEntityPlayer();
        if (event instanceof PlayerInteractEvent.LeftClickBlock) {
            this.checkCreativeClick(event);
        } else if (event instanceof PlayerInteractEvent.RightClickBlock && player.func_70093_af() && ((heldItem = player.func_184614_ca()).func_190926_b() || !(heldItem.func_77973_b() instanceof SmartWrench))) {
            world = event.getWorld();
            IBlockState state = world.func_180495_p(event.getPos());
            Block block = state.func_177230_c();
            if (block instanceof ScreenBlock) {
                Vec3d vec = ((PlayerInteractEvent.RightClickBlock)event).getHitVec();
                ((ScreenBlock)block).activate(world, event.getPos(), state, player, event.getHand(), event.getFace(), (float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c);
                ((PlayerInteractEvent.RightClickBlock)event).setUseItem(Event.Result.DENY);
                return;
            }
            if (block instanceof ScreenHitBlock) {
                Vec3d vec = ((PlayerInteractEvent.RightClickBlock)event).getHitVec();
                ((ScreenHitBlock)block).activate(world, event.getPos(), state, player, event.getHand(), event.getFace(), (float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c);
                ((PlayerInteractEvent.RightClickBlock)event).setUseItem(Event.Result.DENY);
                return;
            }
        }
        heldItem = player.func_184586_b(event.getHand());
        if (heldItem.func_190926_b() || heldItem.func_77973_b() == null) {
            return;
        }
        if (BlockProtectorConfiguration.enabled && player.func_70093_af() && WrenchChecker.isAWrench((Item)heldItem.func_77973_b())) {
            Collection<GlobalCoordinate> protectors;
            int z;
            int y;
            if (heldItem.func_77973_b() instanceof SmartWrenchItem && SmartWrenchItem.getCurrentMode(heldItem) == SmartWrenchMode.MODE_SELECT) {
                return;
            }
            world = event.getWorld();
            int x = event.getPos().func_177958_n();
            if (BlockProtectors.checkHarvestProtection(x, y = event.getPos().func_177956_o(), z = event.getPos().func_177952_p(), (IBlockAccess)world, protectors = BlockProtectors.getProtectors(world, x, y, z))) {
                event.setCanceled(true);
            }
        }
    }

    private void checkCreativeClick(PlayerInteractEvent event) {
        Block block;
        if (event.getEntityPlayer().func_184812_l_() && ((block = event.getWorld().func_180495_p(event.getPos()).func_177230_c()) == ScreenSetup.screenBlock || block == ScreenSetup.creativeScreenBlock || block == ScreenSetup.screenHitBlock) && !event.getEntityPlayer().func_70093_af()) {
            if (event.getWorld().field_72995_K) {
                block.func_180649_a(event.getWorld(), event.getPos(), event.getEntityPlayer());
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityTeleport(EnderTeleportEvent event) {
        BlockPos coordinate;
        World world = event.getEntity().func_130014_f_();
        int id = world.field_73011_w.getDimension();
        Entity entity = event.getEntity();
        if (NoTeleportAreaManager.isTeleportPrevented(entity, new GlobalCoordinate(coordinate = new BlockPos((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v), id))) {
            event.setCanceled(true);
        } else {
            coordinate = new BlockPos((int)event.getTargetX(), (int)event.getTargetY(), (int)event.getTargetZ());
            if (NoTeleportAreaManager.isTeleportPrevented(entity, new GlobalCoordinate(coordinate, id))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        BlockPos coordinate;
        World world = event.getWorld();
        int id = world.field_73011_w.getDimension();
        Entity entity = event.getEntity();
        if (entity instanceof IMob && PeacefulAreaManager.isPeaceful(new GlobalCoordinate(coordinate = new BlockPos((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v), id))) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath() && event.getOriginal().hasCapability(PlayerExtendedProperties.FAVORITE_DESTINATIONS_CAPABILITY, null)) {
            FavoriteDestinationsProperties oldFavorites = (FavoriteDestinationsProperties)event.getOriginal().getCapability(PlayerExtendedProperties.FAVORITE_DESTINATIONS_CAPABILITY, null);
            FavoriteDestinationsProperties newFavorites = PlayerExtendedProperties.getFavoriteDestinations(event.getEntityPlayer());
            newFavorites.copyFrom(oldFavorites);
        }
    }

    @SubscribeEvent
    public void onPostWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K) {
            for (EndergenicTileEntity endergenic : EndergenicTileEntity.todoEndergenics) {
                endergenic.checkStateServer();
            }
            EndergenicTileEntity.todoEndergenics.clear();
            EndergenicTileEntity.endergenicsAdded.clear();
        }
    }
}

