/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.builder.BuilderBlock;
import mcjty.rftools.blocks.builder.SpaceChamberBlock;
import mcjty.rftools.blocks.builder.SpaceChamberControllerBlock;
import mcjty.rftools.blocks.builder.SupportBlock;
import mcjty.rftools.blocks.shaper.ComposerBlock;
import mcjty.rftools.blocks.shaper.LocatorBlock;
import mcjty.rftools.blocks.shaper.ProjectorBlock;
import mcjty.rftools.blocks.shaper.RemoteScannerBlock;
import mcjty.rftools.blocks.shaper.ScannerBlock;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.items.builder.SpaceChamberCardItem;
import mcjty.rftools.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BuilderSetup {
    public static SpaceChamberBlock spaceChamberBlock;
    public static SpaceChamberControllerBlock spaceChamberControllerBlock;
    public static BuilderBlock builderBlock;
    public static SupportBlock supportBlock;
    public static ComposerBlock composerBlock;
    public static ScannerBlock scannerBlock;
    public static RemoteScannerBlock remoteScannerBlock;
    public static ProjectorBlock projectorBlock;
    public static LocatorBlock locatorBlock;
    public static SpaceChamberCardItem spaceChamberCardItem;
    public static ShapeCardItem shapeCardItem;
    private static Map<String, BlockInformation> blockInformationMap;

    public static void init() {
        spaceChamberBlock = new SpaceChamberBlock();
        spaceChamberControllerBlock = new SpaceChamberControllerBlock();
        builderBlock = new BuilderBlock();
        supportBlock = new SupportBlock();
        composerBlock = new ComposerBlock();
        scannerBlock = new ScannerBlock();
        remoteScannerBlock = new RemoteScannerBlock();
        projectorBlock = new ProjectorBlock();
        locatorBlock = new LocatorBlock();
        BuilderSetup.initItems();
        BuilderSetup.readBuilderBlocksInternal();
        BuilderSetup.readBuilderBlocksConfig();
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        spaceChamberBlock.initModel();
        spaceChamberControllerBlock.initModel();
        builderBlock.initModel();
        supportBlock.initModel();
        composerBlock.initModel();
        scannerBlock.initModel();
        remoteScannerBlock.initModel();
        projectorBlock.initModel();
        locatorBlock.initModel();
        spaceChamberCardItem.initModel();
        shapeCardItem.initModel();
    }

    private static void initItems() {
        spaceChamberCardItem = new SpaceChamberCardItem();
        shapeCardItem = new ShapeCardItem();
    }

    private static void readBuilderBlocksInternal() {
        try (InputStream inputstream = RFTools.class.getResourceAsStream("/assets/rftools/text/builder.json");){
            BuilderSetup.parseBuilderJson(inputstream);
        }
        catch (IOException e) {
            Logging.logError((String)"Error reading builder.json", (Throwable)e);
        }
    }

    private static void readBuilderBlocksConfig() {
        File modConfigDir = CommonProxy.modConfigDir;
        File file = new File(modConfigDir.getPath() + File.separator + "rftools", "userbuilder.json");
        try (FileInputStream inputstream = new FileInputStream(file);){
            BuilderSetup.parseBuilderJson(inputstream);
        }
        catch (IOException e) {
            Logging.log((String)"Could not read 'userbuilder.json', this is not an error!");
        }
    }

    private static void parseBuilderJson(InputStream inputstream) throws UnsupportedEncodingException {
        BufferedReader br = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse((Reader)br);
        for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
            if ("movables".equals(entry.getKey())) {
                BuilderSetup.readMovablesFromJson((JsonElement)entry.getValue());
                continue;
            }
            if (!"rotatables".equals(entry.getKey())) continue;
            BuilderSetup.readRotatablesFromJson((JsonElement)entry.getValue());
        }
    }

    private static void readMovablesFromJson(JsonElement element) {
        for (JsonElement entry : element.getAsJsonArray()) {
            String blockName = entry.getAsJsonArray().get(0).getAsString();
            String warningType = entry.getAsJsonArray().get(1).getAsString();
            double costFactor = entry.getAsJsonArray().get(2).getAsDouble();
            int status = "-".equals(warningType) ? 2 : ("+".equals(warningType) ? 0 : 1);
            BlockInformation old = blockInformationMap.get(blockName);
            if (old == null) {
                old = BlockInformation.OK;
            }
            blockInformationMap.put(blockName, new BlockInformation(old, blockName, status, costFactor));
        }
    }

    private static void readRotatablesFromJson(JsonElement element) {
        for (JsonElement entry : element.getAsJsonArray()) {
            String blockName = entry.getAsJsonArray().get(0).getAsString();
            String rotatable = entry.getAsJsonArray().get(1).getAsString();
            BlockInformation old = blockInformationMap.get(blockName);
            if (old == null) {
                old = BlockInformation.OK;
            }
            blockInformationMap.put(blockName, new BlockInformation(old, rotatable));
        }
    }

    public static BlockInformation getBlockInformation(Block block) {
        BlockInformation information = blockInformationMap.get(block.getRegistryName().toString());
        if (information == null) {
            String modid = BlockTools.getModidForBlock((Block)block);
            information = blockInformationMap.get("modid:" + modid);
        }
        return information;
    }

    static {
        blockInformationMap = new HashMap<String, BlockInformation>();
    }

    public static class BlockInformation {
        private final String blockName;
        private final int blockLevel;
        private final double costFactor;
        private final int rotateInfo;
        public static final int ROTATE_invalid = -1;
        public static final int ROTATE_mmmm = 0;
        public static final int ROTATE_mfff = 1;
        public static final BlockInformation INVALID = new BlockInformation("", 2, 1.0);
        public static final BlockInformation OK = new BlockInformation("", 0, 1.0, 0);
        public static final BlockInformation FREE = new BlockInformation("", 0, 0.0, 0);

        private static int rotateStringToId(String rotateString) {
            if ("mmmm".equals(rotateString)) {
                return 0;
            }
            if ("mfff".equals(rotateString)) {
                return 1;
            }
            return -1;
        }

        public BlockInformation(String blockName, int blockLevel, double costFactor) {
            this.blockName = blockName;
            this.blockLevel = blockLevel;
            this.costFactor = costFactor;
            this.rotateInfo = 0;
        }

        public BlockInformation(String blockName, int blockLevel, double costFactor, int rotateInfo) {
            this.blockName = blockName;
            this.blockLevel = blockLevel;
            this.costFactor = costFactor;
            this.rotateInfo = rotateInfo;
        }

        public BlockInformation(BlockInformation other, String rotateInfo) {
            this(other.blockName, other.blockLevel, other.costFactor, BlockInformation.rotateStringToId(rotateInfo));
        }

        public BlockInformation(BlockInformation other, String blockName, int blockLevel, double costFactor) {
            this(blockName, blockLevel, costFactor, other.rotateInfo);
        }

        public int getBlockLevel() {
            return this.blockLevel;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public double getCostFactor() {
            return this.costFactor;
        }

        public int getRotateInfo() {
            return this.rotateInfo;
        }
    }
}

