/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.Counter;
import mcjty.rftools.blocks.builder.BuilderConfiguration;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.builder.BuilderTileEntity;
import mcjty.rftools.blocks.builder.PacketChamberInfoReady;
import mcjty.rftools.blocks.builder.SpaceChamberRepository;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BuilderTools {
    public static void returnChamberInfo(EntityPlayer player) {
        ItemStack cardItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (cardItem.func_190926_b() || cardItem.func_77978_p() == null) {
            return;
        }
        int channel = cardItem.func_77978_p().func_74762_e("channel");
        if (channel == -1) {
            return;
        }
        SpaceChamberRepository repository = SpaceChamberRepository.getChannels(player.func_130014_f_());
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        if (chamberChannel == null) {
            return;
        }
        int dimension = chamberChannel.getDimension();
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world == null) {
            return;
        }
        Counter blocks = new Counter();
        Counter costs = new Counter();
        HashMap<IBlockState, ItemStack> stacks = new HashMap<IBlockState, ItemStack>();
        BlockPos minCorner = chamberChannel.getMinCorner();
        BlockPos maxCorner = chamberChannel.getMaxCorner();
        BuilderTools.findBlocks((World)world, (Counter<IBlockState>)blocks, (Counter<IBlockState>)costs, stacks, minCorner, maxCorner);
        Counter entitiesWithCount = new Counter();
        Counter entitiesWithCost = new Counter();
        HashMap<String, Entity> firstEntity = new HashMap<String, Entity>();
        BuilderTools.findEntities((World)world, minCorner, maxCorner, (Counter<String>)entitiesWithCount, (Counter<String>)entitiesWithCost, firstEntity);
        RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketChamberInfoReady((Map<IBlockState, Integer>)blocks, (Map<IBlockState, Integer>)costs, stacks, (Map<String, Integer>)entitiesWithCount, (Map<String, Integer>)entitiesWithCost, firstEntity), (EntityPlayerMP)player);
    }

    private static void findEntities(World world, BlockPos minCorner, BlockPos maxCorner, Counter<String> entitiesWithCount, Counter<String> entitiesWithCost, Map<String, Entity> firstEntity) {
        List entities = world.func_72839_b(null, new AxisAlignedBB((double)minCorner.func_177958_n(), (double)minCorner.func_177956_o(), (double)minCorner.func_177952_p(), (double)(maxCorner.func_177958_n() + 1), (double)(maxCorner.func_177956_o() + 1), (double)(maxCorner.func_177952_p() + 1)));
        for (Entity entity : entities) {
            EntityItem entityItem;
            String canonicalName = entity.getClass().getCanonicalName();
            if (entity instanceof EntityItem && !(entityItem = (EntityItem)entity).func_92059_d().func_190926_b()) {
                String displayName = entityItem.func_92059_d().func_82833_r();
                canonicalName = canonicalName + " (" + displayName + ")";
            }
            entitiesWithCount.increment((Object)canonicalName);
            if (!firstEntity.containsKey(canonicalName)) {
                firstEntity.put(canonicalName, entity);
            }
            if (entity instanceof EntityPlayer) {
                entitiesWithCost.increment((Object)canonicalName, BuilderConfiguration.builderRfPerPlayer);
                continue;
            }
            entitiesWithCost.increment((Object)canonicalName, BuilderConfiguration.builderRfPerEntity);
        }
    }

    private static void findBlocks(World world, Counter<IBlockState> blocks, Counter<IBlockState> costs, Map<IBlockState, ItemStack> stacks, BlockPos minCorner, BlockPos maxCorner) {
        for (int x = minCorner.func_177958_n(); x <= maxCorner.func_177958_n(); ++x) {
            for (int y = minCorner.func_177956_o(); y <= maxCorner.func_177956_o(); ++y) {
                for (int z = minCorner.func_177952_p(); z <= maxCorner.func_177952_p(); ++z) {
                    TileEntity te;
                    BuilderSetup.BlockInformation info;
                    ItemStack item;
                    Block block;
                    BlockPos p = new BlockPos(x, y, z);
                    IBlockState state = world.func_180495_p(p);
                    if (BuilderTileEntity.isEmpty(state, block = state.func_177230_c())) continue;
                    blocks.increment((Object)state);
                    if (!stacks.containsKey(state) && !(item = block.func_185473_a(world, p, state)).func_190926_b()) {
                        stacks.put(state, item);
                    }
                    if ((info = BuilderTileEntity.getBlockInformation(world, p, block, te = world.func_175625_s(p))).getBlockLevel() == 2) {
                        costs.put((Object)state, (Object)-1);
                        continue;
                    }
                    costs.increment((Object)state, (int)((double)BuilderConfiguration.builderRfPerOperation * info.getCostFactor()));
                }
            }
        }
    }
}

