/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.elevator;

import java.util.List;
import mcjty.lib.api.Infusable;
import mcjty.lib.container.BaseBlock;
import mcjty.lib.container.EmptyContainer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.elevator.ElevatorTESR;
import mcjty.rftools.blocks.elevator.ElevatorTileEntity;
import mcjty.rftools.blocks.elevator.GuiElevator;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ElevatorBlock
extends GenericRFToolsBlock<ElevatorTileEntity, EmptyContainer>
implements Infusable {
    public ElevatorBlock() {
        super(Material.field_151573_f, ElevatorTileEntity.class, EmptyContainer.class, "elevator", true);
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.HORIZROTATION;
    }

    public boolean needsRedstoneCheck() {
        return true;
    }

    public boolean hasRedstoneOutput() {
        return true;
    }

    protected int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te;
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)FACING_HORIZ);
        if (side == direction && (te = world.func_175625_s(pos)) instanceof ElevatorTileEntity) {
            ElevatorTileEntity elevatorTileEntity = (ElevatorTileEntity)te;
            return elevatorTileEntity.isPlatformHere() ? 15 : 0;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        ClientRegistry.bindTileEntitySpecialRenderer(ElevatorTileEntity.class, (TileEntitySpecialRenderer)new ElevatorTESR());
    }

    public int getGuiID() {
        return RFTools.GUI_ELEVATOR;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<GuiElevator> getGuiClass() {
        return GuiElevator.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This machine needs to be placed at a certain");
            list.add(TextFormatting.WHITE + "level pointing towards where a moving platform");
            list.add(TextFormatting.WHITE + "will be. Only the lowest elevator needs power");
            list.add(TextFormatting.WHITE + "Infusing bonus: reduced power consumption");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ElevatorTileEntity) {
            ElevatorTileEntity elevatorTileEntity = (ElevatorTileEntity)te;
            elevatorTileEntity.clearCaches((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BaseBlock.FACING_HORIZ));
        }
        if (placer instanceof EntityPlayer) {
            // empty if block
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ElevatorTileEntity) {
            ElevatorTileEntity elevatorTileEntity = (ElevatorTileEntity)te;
            elevatorTileEntity.clearCaches((EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING_HORIZ));
        }
        super.func_180663_b(world, pos, state);
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof ElevatorTileEntity) {
            ElevatorTileEntity elevatorTileEntity = (ElevatorTileEntity)te;
            probeInfo.text(TextFormatting.BLUE + "Name: " + elevatorTileEntity.getName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        ElevatorTileEntity te = (ElevatorTileEntity)accessor.getTileEntity();
        int energy = te.getEnergyStored();
        currenttip.add(TextFormatting.GREEN + "RF: " + energy);
        if (te.getName() != null && !te.getName().isEmpty()) {
            currenttip.add(TextFormatting.BLUE + "Name: " + te.getName());
        }
        return currenttip;
    }
}

