/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.MachineInformation;
import mcjty.lib.api.information.IMachineInformation;
import mcjty.lib.compat.RedstoneFluxCompatibility;
import mcjty.lib.entity.GenericEnergyProviderTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.Arguments;
import mcjty.lib.network.PacketSendClientCommand;
import mcjty.lib.network.PacketServerCommand;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.endergen.EnderMonitorMode;
import mcjty.rftools.blocks.endergen.EnderMonitorTileEntity;
import mcjty.rftools.blocks.endergen.EndergenicConfiguration;
import mcjty.rftools.blocks.endergen.EndergenicPearl;
import mcjty.rftools.blocks.endergen.EndergenicSetup;
import mcjty.rftools.blocks.endergen.GuiEndergenic;
import mcjty.rftools.blocks.endergen.PearlInjectorTileEntity;
import mcjty.rftools.hud.IHudSupport;
import mcjty.rftools.network.PacketGetHudLog;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.typed.Type;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EndergenicTileEntity
extends GenericEnergyProviderTileEntity
implements ITickable,
MachineInformation,
IHudSupport,
IMachineInformation {
    private static Random random = new Random();
    public static final String CMD_SETDESTINATION = "setDest";
    public static final String CMD_GETSTAT_RF = "getStatRF";
    public static final String CLIENTCMD_GETSTAT_RF = "getStatRF";
    public static final String CMD_GETSTAT_LOST = "getStatLost";
    public static final String CLIENTCMD_GETSTAT_LOST = "getStatLost";
    public static final String CMD_GETSTAT_LAUNCHED = "getStatLaunched";
    public static final String CLIENTCMD_GETSTAT_LAUNCHED = "getStatLaunched";
    public static final String CMD_GETSTAT_OPPORTUNITIES = "getStatOpp";
    public static final String CLIENTCMD_GETSTAT_OPPORTUNITIES = "getStatOpp";
    private static final String[] TAGS = new String[]{"rftick", "lost", "launched", "opportunities"};
    private static final String[] TAG_DESCRIPTIONS = new String[]{"Average RF/tick for the last 5 seconds", "Amount of pearls that were lost during the last 5 seconds", "Amount of pearls that were launched during the last 5 seconds", "Number of opportunities for the last 5 seconds"};
    public static final int CHARGE_IDLE = 0;
    public static final int CHARGE_HOLDING = -1;
    private int chargingMode = 0;
    private int currentAge = 0;
    private BlockPos destination = null;
    private int distance = 0;
    private boolean prevIn = false;
    private int rfGained = 0;
    private int rfLost = 0;
    private int pearlsLaunched = 0;
    private int pearlsLost = 0;
    private int chargeCounter = 0;
    private int pearlArrivedAt = -2;
    private int ticks = 100;
    private int lastRfPerTick = 0;
    private int lastRfGained = 0;
    private int lastRfLost = 0;
    private int lastPearlsLost = 0;
    private int lastPearlsLaunched = 0;
    private int lastChargeCounter = 0;
    private int lastPearlArrivedAt = 0;
    private String lastPearlsLostReason = "";
    private List<EndergenicPearl> pearls = new ArrayList<EndergenicPearl>();
    private long lastHudTime = 0L;
    private List<String> clientHudLog = new ArrayList<String>();
    private int badCounter = 0;
    private int goodCounter = 0;
    private static int[] rfPerHit = new int[]{0, 100, 150, 200, 400, 800, 1600, 3200, 6400, 8000, 12800, 8000, 6400, 2500, 1000, 100};
    private int tickCounter = 0;
    public static List<EndergenicTileEntity> todoEndergenics = new ArrayList<EndergenicTileEntity>();
    public static Set<GlobalCoordinate> endergenicsAdded = new HashSet<GlobalCoordinate>();
    public static final EnumFacing[] HORIZ_DIRECTIONS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};

    public EndergenicTileEntity() {
        super(5000000, 20000);
    }

    public int getEnergyDiffPerTick() {
        return this.rfGained - this.rfLost;
    }

    @Nullable
    public String getEnergyUnitName() {
        return "RF";
    }

    public boolean isMachineActive() {
        return true;
    }

    public boolean isMachineRunning() {
        return true;
    }

    @Nullable
    public String getMachineStatus() {
        return null;
    }

    public void func_73660_a() {
        if (this.badCounter > 0) {
            --this.badCounter;
            this.markDirtyQuick();
        }
        if (this.goodCounter > 0) {
            --this.goodCounter;
            this.markDirtyQuick();
        }
        if (!this.func_145831_w().field_72995_K) {
            this.queueWork();
        }
    }

    private void queueWork() {
        GlobalCoordinate gc = new GlobalCoordinate(this.func_174877_v(), this.func_145831_w().field_73011_w.getDimension());
        if (endergenicsAdded.contains(gc)) {
            return;
        }
        EndergenicTileEntity endergenicWithInjector = this.findEndergenicWithInjector(new HashSet<BlockPos>());
        if (endergenicWithInjector != null) {
            HashSet<BlockPos> done = new HashSet<BlockPos>();
            EndergenicTileEntity loop = endergenicWithInjector;
            while (loop != null) {
                done.add(loop.func_174877_v());
                this.addToQueue(loop, new GlobalCoordinate(loop.func_174877_v(), this.func_145831_w().field_73011_w.getDimension()));
                if ((loop = loop.getDestinationTE()) != null && !done.contains(loop.func_174877_v())) continue;
                loop = null;
            }
        }
        this.addToQueue(this, gc);
    }

    private void addToQueue(EndergenicTileEntity endergenicWithInjector, GlobalCoordinate gc2) {
        if (!endergenicsAdded.contains(gc2)) {
            todoEndergenics.add(endergenicWithInjector);
            endergenicsAdded.add(gc2);
        }
    }

    private EndergenicTileEntity findEndergenicWithInjector(Set<BlockPos> done) {
        if (this.hasInjector()) {
            return this;
        }
        if (this.destination == null) {
            return null;
        }
        done.add(this.func_174877_v());
        if (done.contains(this.destination)) {
            return null;
        }
        TileEntity te = this.func_145831_w().func_175625_s(this.destination);
        if (te instanceof EndergenicTileEntity) {
            return ((EndergenicTileEntity)te).findEndergenicWithInjector(done);
        }
        return null;
    }

    private boolean hasInjector() {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            PearlInjectorTileEntity injector;
            EndergenicTileEntity endergenic;
            TileEntity te;
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v().func_177972_a(dir));
            if (state.func_177230_c() != EndergenicSetup.pearlInjectorBlock || !((te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir))) instanceof PearlInjectorTileEntity) || (endergenic = (injector = (PearlInjectorTileEntity)te).findEndergenicTileEntity()) != this) continue;
            return true;
        }
        return false;
    }

    @Override
    public EnumFacing getBlockOrientation() {
        return null;
    }

    @Override
    public boolean isBlockAboveAir() {
        return this.func_145831_w().func_175623_d(this.field_174879_c.func_177984_a());
    }

    public List<String> getHudLog() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TextFormatting.BLUE + "Last 5 seconds:");
        list.add("    Charged: " + this.getLastChargeCounter());
        list.add("    Fired: " + this.getLastPearlsLaunched());
        list.add("    Lost: " + this.getLastPearlsLost());
        if (this.getLastPearlsLost() > 0) {
            list.add(TextFormatting.RED + "    " + this.getLastPearlsLostReason());
        }
        if (this.getLastPearlArrivedAt() > -2) {
            list.add("    Last pearl at " + this.getLastPearlArrivedAt());
        }
        list.add(TextFormatting.BLUE + "Power:");
        list.add(TextFormatting.GREEN + "    RF Gain " + this.getLastRfGained());
        list.add(TextFormatting.RED + "    RF Lost " + this.getLastRfLost());
        list.add(TextFormatting.GREEN + "    RF/t " + this.getLastRfPerTick());
        return list;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    @Override
    public List<String> getClientLog() {
        return this.clientHudLog;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastHudTime;
    }

    @Override
    public void setLastUpdateTime(long t) {
        this.lastHudTime = t;
    }

    public int getBadCounter() {
        return this.badCounter;
    }

    public int getLastRfPerTick() {
        return this.lastRfPerTick;
    }

    public int getLastRfGained() {
        return this.lastRfGained;
    }

    public int getLastRfLost() {
        return this.lastRfLost;
    }

    public int getLastPearlsLost() {
        return this.lastPearlsLost;
    }

    public int getLastPearlsLaunched() {
        return this.lastPearlsLaunched;
    }

    public int getLastChargeCounter() {
        return this.lastChargeCounter;
    }

    public int getLastPearlArrivedAt() {
        return this.lastPearlArrivedAt;
    }

    public String getLastPearlsLostReason() {
        return this.lastPearlsLostReason;
    }

    public int getGoodCounter() {
        return this.goodCounter;
    }

    public void checkStateServer() {
        ++this.tickCounter;
        --this.ticks;
        if (this.ticks < 0) {
            this.lastRfGained = this.rfGained;
            this.lastRfLost = this.rfLost;
            this.lastRfPerTick = (this.rfGained - this.rfLost) / 100;
            this.lastPearlsLost = this.pearlsLost;
            this.lastPearlsLaunched = this.pearlsLaunched;
            this.lastChargeCounter = this.chargeCounter;
            this.lastPearlArrivedAt = this.pearlArrivedAt;
            this.ticks = 100;
            this.rfGained = 0;
            this.rfLost = 0;
            this.pearlsLaunched = 0;
            this.pearlsLost = 0;
            this.chargeCounter = 0;
            this.pearlArrivedAt = -2;
        }
        this.handlePearls();
        this.handleSendingEnergy();
        if (this.chargingMode == -1 && random.nextInt(1000) <= EndergenicConfiguration.chanceLost) {
            this.log("Server Tick: discard pearl randomly");
            this.discardPearl("Random pearl discard");
        }
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        boolean bl = this.prevIn = this.powerLevel > 0;
        if (pulse) {
            if (this.chargingMode == 0) {
                this.log("Server Tick: pulse -> start charging");
                this.startCharging();
                return;
            }
            if (this.chargingMode == -1) {
                this.log("Server Tick: pulse -> fire pearl");
                this.firePearl();
                return;
            }
        }
        if (this.chargingMode == 0) {
            return;
        }
        if (this.chargingMode == -1) {
            int rf = EndergenicConfiguration.rfToHoldPearl;
            rf = (int)((float)rf * (3.0f - this.getInfusedFactor()) / 3.0f);
            int rfStored = this.getEnergyStored();
            if (rfStored < rf) {
                this.log("Server Tick: insufficient energy to hold pearl (" + rfStored + " vs " + rf + ")");
                this.discardPearl("Not enough energy to hold pearl");
            } else {
                int rfExtracted = this.storage.extractEnergy(rf, false);
                this.log("Server Tick: holding pearl, consume " + rfExtracted + " RF");
                this.rfLost += rfExtracted;
            }
            return;
        }
        this.markDirtyQuick();
        ++this.chargingMode;
        if (this.chargingMode >= 16) {
            this.log("Server Tick: charging mode ends -> idle");
            this.chargingMode = 0;
        }
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getTagCount() {
        return TAGS.length;
    }

    public String getTagName(int index) {
        return TAGS[index];
    }

    public String getTagDescription(int index) {
        return TAG_DESCRIPTIONS[index];
    }

    public String getData(int index, long millis) {
        switch (index) {
            case 0: {
                return Integer.toString(this.lastRfPerTick);
            }
            case 1: {
                return Integer.toString(this.lastPearlsLost);
            }
            case 2: {
                return Integer.toString(this.lastPearlsLaunched);
            }
            case 3: {
                return Integer.toString(this.lastChargeCounter);
            }
        }
        return null;
    }

    private void log(String message) {
    }

    private void fireMonitors(EnderMonitorMode mode) {
        BlockPos pos = this.func_174877_v();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            EnderMonitorTileEntity enderMonitorTileEntity;
            EnumFacing inputSide;
            BlockPos c = pos.func_177972_a(dir);
            TileEntity te = this.func_145831_w().func_175625_s(c);
            if (!(te instanceof EnderMonitorTileEntity) || (inputSide = (enderMonitorTileEntity = (EnderMonitorTileEntity)te).getFacing(this.func_145831_w().func_180495_p(c)).getInputSide()) != dir.func_176734_d()) continue;
            enderMonitorTileEntity.fireFromEndergenic(mode);
        }
    }

    private void handleSendingEnergy() {
        int energyStored = this.getEnergyStored();
        if (energyStored <= EndergenicConfiguration.keepRfInBuffer) {
            return;
        }
        energyStored -= EndergenicConfiguration.keepRfInBuffer;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos o = this.func_174877_v().func_177972_a(dir);
            TileEntity te = this.func_145831_w().func_175625_s(o);
            EnumFacing opposite = dir.func_176734_d();
            if (!EnergyTools.isEnergyTE((TileEntity)te) && (te == null || !te.hasCapability(CapabilityEnergy.ENERGY, opposite))) continue;
            int rfToGive = EndergenicConfiguration.rfOutput <= energyStored ? EndergenicConfiguration.rfOutput : energyStored;
            int received = RFTools.redstoneflux && RedstoneFluxCompatibility.isEnergyConnection((TileEntity)te) ? (RedstoneFluxCompatibility.canConnectEnergy((TileEntity)te, (EnumFacing)opposite) ? EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (int)rfToGive) : 0) : EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (int)rfToGive);
            if ((energyStored -= this.storage.extractEnergy(received, false)) <= 0) break;
        }
    }

    private void handlePearls() {
        if (this.pearls.isEmpty()) {
            return;
        }
        ArrayList<EndergenicPearl> newlist = new ArrayList<EndergenicPearl>();
        for (EndergenicPearl pearl : this.pearls) {
            this.log("Pearls: age=" + pearl.getAge() + ", ticks left=" + pearl.getTicksLeft());
            if (pearl.handleTick(this.func_145831_w())) continue;
            newlist.add(pearl);
        }
        this.pearls = newlist;
    }

    private void markDirtyClientNoRender() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_175661_b(EntityPlayer.class, p -> this.func_174877_v().func_177954_c(p.field_70165_t, p.field_70163_u, p.field_70161_v) < 1024.0).stream().forEach(p -> RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketSendClientCommand("rftools", "flashEndergenic", Arguments.builder().value(this.func_174877_v()).value(this.goodCounter).value(this.badCounter).build()), (EntityPlayerMP)p));
        }
    }

    public void syncCountersFromServer(int goodCounter, int badCounter) {
        this.goodCounter = goodCounter;
        this.badCounter = badCounter;
    }

    private void discardPearl(String reason) {
        this.badCounter = 20;
        this.markDirtyClientNoRender();
        ++this.pearlsLost;
        this.lastPearlsLostReason = reason;
        this.chargingMode = 0;
        this.fireMonitors(EnderMonitorMode.MODE_LOSTPEARL);
    }

    private EndergenicTileEntity getDestinationTE() {
        if (this.destination == null) {
            return null;
        }
        TileEntity te = this.func_145831_w().func_175625_s(this.destination);
        if (te instanceof EndergenicTileEntity) {
            return (EndergenicTileEntity)te;
        }
        this.destination = null;
        this.markDirtyClient();
        return null;
    }

    public void firePearl() {
        this.markDirtyQuick();
        this.getDestinationTE();
        if (this.destination == null) {
            this.log("Fire Pearl: pearl lost due to lack of destination");
            this.discardPearl("Missing destination");
        } else {
            this.log("Fire Pearl: pearl is launched to " + this.destination.func_177958_n() + "," + this.destination.func_177956_o() + "," + this.destination.func_177952_p());
            this.chargingMode = 0;
            ++this.pearlsLaunched;
            this.pearls.add(new EndergenicPearl(this.distance, this.destination, this.currentAge + 1));
            this.fireMonitors(EnderMonitorMode.MODE_PEARLFIRED);
        }
    }

    public void firePearlFromInjector() {
        this.markDirtyQuick();
        this.getDestinationTE();
        this.chargingMode = 0;
        if (this.destination == null) {
            this.log("Fire Pearl from injector: pearl lost due to lack of destination");
            this.discardPearl("Missing destination");
        } else {
            this.log("Fire Pearl from injector: pearl is launched to " + this.destination.func_177958_n() + "," + this.destination.func_177956_o() + "," + this.destination.func_177952_p());
            ++this.pearlsLaunched;
            this.pearls.add(new EndergenicPearl(this.distance, this.destination, 0));
            this.fireMonitors(EnderMonitorMode.MODE_PEARLFIRED);
        }
    }

    public void receivePearl(int age) {
        this.fireMonitors(EnderMonitorMode.MODE_PEARLARRIVED);
        this.markDirtyQuick();
        if (this.chargingMode == -1) {
            this.log("Receive Pearl: pearl arrives but already holding -> both are lost");
            this.discardPearl("Pearl arrived while holding");
        } else if (this.chargingMode == 0) {
            this.log("Receive Pearl: pearl arrives but generator is idle -> pearl is lost");
            this.discardPearl("Pearl arrived while idle");
        } else {
            this.pearlArrivedAt = this.chargingMode;
            int rf = (int)((double)rfPerHit[this.chargingMode] * EndergenicConfiguration.powergenFactor);
            rf = (int)((float)rf * (this.getInfusedFactor() + 2.0f) / 2.0f);
            int a = age * 5;
            if (a > 100) {
                a = 100;
            }
            rf += rf * a / 100;
            this.rfGained += rf;
            this.log("Receive Pearl: pearl arrives at tick " + this.chargingMode + ", age=" + age + ", RF=" + rf);
            this.modifyEnergyStored(rf);
            this.goodCounter = 10;
            this.markDirtyClientNoRender();
            this.chargingMode = -1;
            this.currentAge = age;
        }
    }

    public void startCharging() {
        this.markDirtyQuick();
        this.chargingMode = 1;
        ++this.chargeCounter;
    }

    public void useWrench(EntityPlayer player) {
        BlockPos thisCoord = this.func_174877_v();
        BlockPos coord = RFTools.instance.clientInfo.getSelectedTE();
        TileEntity tileEntity = null;
        if (coord != null) {
            tileEntity = this.func_145831_w().func_175625_s(coord);
        }
        if (!(tileEntity instanceof EndergenicTileEntity)) {
            RFTools.instance.clientInfo.setSelectedTE(thisCoord);
            EndergenicTileEntity destinationTE = this.getDestinationTE();
            if (destinationTE == null) {
                RFTools.instance.clientInfo.setDestinationTE(null);
                Logging.message((EntityPlayer)player, (String)"Select another endergenic generator as destination");
            } else {
                RFTools.instance.clientInfo.setDestinationTE(destinationTE.func_174877_v());
                int distance = this.getDistanceInTicks();
                Logging.message((EntityPlayer)player, (String)("Select another endergenic generator as destination (current distance " + distance + ")"));
            }
        } else if (coord.equals((Object)thisCoord)) {
            RFTools.instance.clientInfo.setSelectedTE(null);
            RFTools.instance.clientInfo.setDestinationTE(null);
        } else {
            EndergenicTileEntity otherTE = (EndergenicTileEntity)tileEntity;
            int distance = otherTE.calculateDistance(thisCoord);
            if (distance >= 5) {
                Logging.warn((EntityPlayer)player, (String)"Distance is too far (maximum 4)");
                return;
            }
            otherTE.setDestination(thisCoord);
            RFTools.instance.clientInfo.setSelectedTE(null);
            RFTools.instance.clientInfo.setDestinationTE(null);
            Logging.message((EntityPlayer)player, (String)("Destination is set (distance " + otherTE.getDistanceInTicks() + " ticks)"));
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public int getChargingMode() {
        return this.chargingMode;
    }

    public int calculateDistance(BlockPos destination) {
        double d = new Vec3d((Vec3i)destination).func_72438_d(new Vec3d((Vec3i)this.func_174877_v()));
        return (int)(d / 3.0) + 1;
    }

    public void setDestination(BlockPos destination) {
        this.markDirtyQuick();
        this.destination = destination;
        this.distance = this.calculateDistance(destination);
        if (this.func_145831_w().field_72995_K) {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketServerCommand(this.func_174877_v(), CMD_SETDESTINATION, new Argument[]{new Argument("dest", destination)}));
        }
    }

    public int getDistanceInTicks() {
        return this.distance;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.chargingMode = tagCompound.func_74762_e("charging");
        this.currentAge = tagCompound.func_74762_e("age");
        this.destination = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"dest");
        this.distance = tagCompound.func_74762_e("distance");
        this.prevIn = tagCompound.func_74767_n("prevIn");
        this.badCounter = tagCompound.func_74771_c("bad");
        this.goodCounter = tagCompound.func_74771_c("good");
        this.pearls.clear();
        NBTTagList list = tagCompound.func_150295_c("pearls", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tc = list.func_150305_b(i);
            EndergenicPearl pearl = new EndergenicPearl(tc);
            this.pearls.add(pearl);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("charging", this.chargingMode);
        tagCompound.func_74768_a("age", this.currentAge);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"dest", (BlockPos)this.destination);
        tagCompound.func_74768_a("distance", this.distance);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        tagCompound.func_74774_a("bad", (byte)this.badCounter);
        tagCompound.func_74774_a("good", (byte)this.goodCounter);
        NBTTagList pearlList = new NBTTagList();
        for (EndergenicPearl pearl : this.pearls) {
            pearlList.func_74742_a((NBTBase)pearl.getTagCompound());
        }
        tagCompound.func_74782_a("pearls", (NBTBase)pearlList);
        return tagCompound;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETDESTINATION.equals(command)) {
            this.setDestination(args.get("dest").getCoordinate());
            return true;
        }
        return false;
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getStatRF".equals(command)) {
            return this.lastRfPerTick;
        }
        if ("getStatLost".equals(command)) {
            return this.lastPearlsLost;
        }
        if ("getStatLaunched".equals(command)) {
            return this.lastPearlsLaunched;
        }
        if ("getStatOpp".equals(command)) {
            return this.lastChargeCounter;
        }
        return null;
    }

    public boolean execute(String command, Integer value) {
        boolean rc = super.execute(command, value);
        if (rc) {
            return true;
        }
        if ("getStatRF".equals(command)) {
            GuiEndergenic.fromServer_lastRfPerTick = value;
            return true;
        }
        if ("getStatLost".equals(command)) {
            GuiEndergenic.fromServer_lastPearlsLost = value;
            return true;
        }
        if ("getStatLaunched".equals(command)) {
            GuiEndergenic.fromServer_lastPearlsLaunched = value;
            return true;
        }
        if ("getStatOpp".equals(command)) {
            GuiEndergenic.fromServer_lastPearlOpportunities = value;
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, Map<String, Argument> args, Type<T> type) {
        List list = super.executeWithResultList(command, args, type);
        if (!list.isEmpty()) {
            return list;
        }
        if (PacketGetHudLog.CMD_GETHUDLOG.equals(command)) {
            return type.convert(this.getHudLog());
        }
        return list;
    }

    public <T> boolean execute(String command, List<T> list, Type<T> type) {
        boolean rc = super.execute(command, list, type);
        if (rc) {
            return true;
        }
        if (PacketGetHudLog.CLIENTCMD_GETHUDLOG.equals(command)) {
            this.clientHudLog = Type.STRING.convert(list);
            return true;
        }
        return false;
    }
}

