/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.generator;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericEnergyStorageTileEntity;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.generator.CoalGeneratorContainer;
import mcjty.rftools.blocks.generator.CoalGeneratorTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiCoalGenerator
extends GenericGuiContainer<CoalGeneratorTileEntity> {
    public static final int INFUSER_WIDTH = 180;
    public static final int INFUSER_HEIGHT = 152;
    private EnergyBar energyBar;
    private ImageChoiceLabel redstoneMode;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/coalgenerator.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public GuiCoalGenerator(CoalGeneratorTileEntity tileEntity, CoalGeneratorContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)tileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "coalgen");
        GenericEnergyStorageTileEntity.setCurrentRF((int)tileEntity.getEnergyStored());
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    private void initRedstoneMode() {
        this.redstoneMode = new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent((parent, newChoice) -> this.changeRedstoneMode()).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        this.redstoneMode.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(154, 46, 16, 16));
        this.redstoneMode.setCurrentChoice(((CoalGeneratorTileEntity)this.tileEntity).getRSMode().ordinal());
    }

    private void changeRedstoneMode() {
        ((CoalGeneratorTileEntity)this.tileEntity).setRSMode(RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()]);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "rsMode", new Argument[]{new Argument("rs", RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()].getDescription())});
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((CoalGeneratorTileEntity)this.tileEntity).getMaxEnergyStored();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 7, 8, 54))).setShowText(false);
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        this.initRedstoneMode();
        Panel toplevel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.energyBar)).addChild((Widget)this.redstoneMode);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        ((CoalGeneratorTileEntity)this.tileEntity).requestRfFromServer("rftools");
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        ((CoalGeneratorTileEntity)this.tileEntity).requestRfFromServer("rftools");
    }
}

