/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.invchecker;

import gnu.trove.TIntCollection;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Map;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.logic.generic.LogicTileEntity;
import mcjty.rftools.blocks.logic.invchecker.InvCheckerContainer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class InvCheckerTileEntity
extends LogicTileEntity
implements ITickable,
DefaultSidedInventory {
    public static final String CMD_SETAMOUNT = "setCounter";
    public static final String CMD_SETSLOT = "setSlot";
    public static final String CMD_SETOREDICT = "setOreDict";
    public static final String CMD_SETMETA = "setUseMeta";
    private int amount = 1;
    private int slot = 0;
    private boolean oreDict = false;
    private boolean useMeta = false;
    private TIntSet set1 = null;
    private int checkCounter = 0;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, InvCheckerContainer.factory, 1);

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.func_70296_d();
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
        this.func_70296_d();
    }

    public boolean isOreDict() {
        return this.oreDict;
    }

    public void setOreDict(boolean oreDict) {
        this.oreDict = oreDict;
        this.func_70296_d();
    }

    public boolean isUseMeta() {
        return this.useMeta;
    }

    public void setUseMeta(boolean useMeta) {
        this.useMeta = useMeta;
        this.func_70296_d();
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.set1 = null;
        this.getInventoryHelper().setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 10;
        this.setRedstoneState(this.checkOutput());
    }

    public boolean checkOutput() {
        boolean newout = false;
        EnumFacing inputSide = this.getFacing(this.func_145831_w().func_180495_p(this.func_174877_v())).getInputSide();
        BlockPos inputPos = this.func_174877_v().func_177972_a(inputSide);
        TileEntity te = this.func_145831_w().func_175625_s(inputPos);
        if (InventoryHelper.isInventory((TileEntity)te)) {
            ItemStack stack = ItemStack.field_190927_a;
            if (CapabilityTools.hasItemCapabilitySafe((TileEntity)te)) {
                IItemHandler capability = CapabilityTools.getItemCapabilitySafe((TileEntity)te);
                if (capability == null) {
                    Block errorBlock = this.func_145831_w().func_180495_p(inputPos).func_177230_c();
                    Logging.logError((String)("Block: " + errorBlock.func_149732_F() + " at " + BlockPosTools.toString((BlockPos)inputPos) + " returns null for getCapability(). Report to mod author"));
                } else if (this.slot >= 0 && this.slot < capability.getSlots()) {
                    stack = capability.getStackInSlot(this.slot);
                }
            } else if (te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                if (this.slot >= 0 && this.slot < inventory.func_70302_i_()) {
                    stack = inventory.func_70301_a(this.slot);
                }
            }
            if (!stack.func_190926_b()) {
                int nr = this.isItemMatching(stack);
                newout = nr >= this.amount;
            }
        }
        return newout;
    }

    private int isItemMatching(ItemStack stack) {
        int nr = 0;
        ItemStack matcher = this.inventoryHelper.getStackInSlot(0);
        if (!matcher.func_190926_b()) {
            if (this.oreDict) {
                if (this.isEqualForOredict(matcher, stack) && (!this.useMeta || matcher.func_77960_j() == stack.func_77960_j())) {
                    nr = stack.func_190916_E();
                }
            } else if (this.useMeta) {
                if (matcher.func_77969_a(stack)) {
                    nr = stack.func_190916_E();
                }
            } else if (matcher.func_77973_b() == stack.func_77973_b()) {
                nr = stack.func_190916_E();
            }
        } else {
            nr = stack.func_190916_E();
        }
        return nr;
    }

    private boolean isEqualForOredict(ItemStack s1, ItemStack s2) {
        if (this.set1 == null) {
            int[] oreIDs1 = OreDictionary.getOreIDs((ItemStack)s1);
            this.set1 = new TIntHashSet(oreIDs1);
        }
        if (this.set1.isEmpty()) {
            return s1.func_77973_b() == s2.func_77973_b();
        }
        int[] oreIDs2 = OreDictionary.getOreIDs((ItemStack)s2);
        if (oreIDs2.length == 0) {
            return false;
        }
        TIntHashSet set2 = new TIntHashSet(oreIDs2);
        set2.retainAll((TIntCollection)this.set1);
        return !set2.isEmpty();
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powered = tagCompound.func_74767_n("rs");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.amount = tagCompound.func_74762_e("amount");
        this.slot = tagCompound.func_74762_e("slot");
        this.oreDict = tagCompound.func_74767_n("oredict");
        this.useMeta = tagCompound.func_74767_n("useMeta");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powered);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("amount", this.amount);
        tagCompound.func_74768_a("slot", this.slot);
        tagCompound.func_74757_a("oredict", this.oreDict);
        tagCompound.func_74757_a("useMeta", this.useMeta);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETAMOUNT.equals(command)) {
            this.setAmount(args.get("amount").getInteger());
            return true;
        }
        if (CMD_SETSLOT.equals(command)) {
            this.setSlot(args.get("slot").getInteger());
            return true;
        }
        if (CMD_SETMETA.equals(command)) {
            this.setUseMeta(args.get("b").getBoolean());
            return true;
        }
        if (CMD_SETOREDICT.equals(command)) {
            this.setOreDict(args.get("b").getBoolean());
            return true;
        }
        return false;
    }
}

