/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.monitor;

import java.util.List;
import mcjty.lib.container.EmptyContainer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.monitor.GuiRFMonitor;
import mcjty.rftools.blocks.monitor.RFMonitorBlockTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class RFMonitorBlock
extends GenericRFToolsBlock<RFMonitorBlockTileEntity, EmptyContainer> {
    @Deprecated
    public static PropertyBool OUTPUTPOWER = PropertyBool.func_177716_a((String)"output");
    public static PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)5);

    public RFMonitorBlock() {
        super(Material.field_151573_f, RFMonitorBlockTileEntity.class, EmptyContainer.class, "rf_monitor", false);
    }

    public boolean hasRedstoneOutput() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        StateMap.Builder ignorePower = new StateMap.Builder().func_178442_a(new IProperty[]{OUTPUTPOWER});
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)ignorePower.func_178441_a());
    }

    public Class<GuiRFMonitor> getGuiClass() {
        return GuiRFMonitor.class;
    }

    public int getGuiID() {
        return RFTools.GUI_RF_MONITOR;
    }

    protected int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (side == direction) {
            TileEntity te = world.func_175625_s(pos);
            if (state.func_177230_c() instanceof RFMonitorBlock && te instanceof RFMonitorBlockTileEntity) {
                RFMonitorBlockTileEntity monitorTileEntity = (RFMonitorBlockTileEntity)te;
                return monitorTileEntity.isPowered() ? 15 : 0;
            }
        }
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        int level = 0;
        if (te instanceof RFMonitorBlockTileEntity) {
            level = ((RFMonitorBlockTileEntity)te).getRflevel();
        }
        return state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(level));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_82609_l[meta & 7]).func_177226_a((IProperty)OUTPUTPOWER, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + ((Boolean)state.func_177229_b((IProperty)OUTPUTPOWER) != false ? 8 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, OUTPUTPOWER, LEVEL});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This device monitors the amount of RF in an adjacent");
            list.add(TextFormatting.WHITE + "machine (select it with the GUI). It can also send");
            list.add(TextFormatting.WHITE + "out a redstone signal if the power goes above or below");
            list.add(TextFormatting.WHITE + "some value.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }
}

