/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import java.util.List;
import java.util.Random;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.BaseBlock;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericBlock;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.screens.ScreenBlock;
import mcjty.rftools.blocks.screens.ScreenHitTileEntity;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ScreenHitBlock
extends GenericBlock<ScreenHitTileEntity, EmptyContainer> {
    public static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

    public ScreenHitBlock() {
        super((ModBase)RFTools.instance, Material.field_151592_s, ScreenHitTileEntity.class, EmptyContainer.class, "screen_hitblock", false);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
    }

    public int getGuiID() {
        return -1;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        BlockPos pos = data.getPos();
        ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.func_175625_s(pos);
        int dx = screenHitTileEntity.getDx();
        int dy = screenHitTileEntity.getDy();
        int dz = screenHitTileEntity.getDz();
        Block block = world.func_180495_p(pos.func_177982_a(dx, dy, dz)).func_177230_c();
        if (block instanceof ScreenBlock) {
            ((ScreenBlock)block).addProbeInfoScreen(mode, probeInfo, player, world, pos.func_177982_a(dx, dy, dz));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te;
        super.getWailaBody(itemStack, currenttip, accessor, config);
        BlockPos pos = accessor.getPosition();
        World world = accessor.getWorld();
        ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.func_175625_s(pos);
        int dx = screenHitTileEntity.getDx();
        int dy = screenHitTileEntity.getDy();
        int dz = screenHitTileEntity.getDz();
        BlockPos rpos = pos.func_177982_a(dx, dy, dz);
        Block block = world.func_180495_p(rpos).func_177230_c();
        if (block instanceof ScreenBlock && (te = world.func_175625_s(rpos)) instanceof ScreenTileEntity) {
            ((ScreenBlock)block).getWailaBodyScreen(currenttip, accessor.getPlayer(), (ScreenTileEntity)te);
        }
        return currenttip;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new ScreenHitTileEntity();
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new ScreenHitTileEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)this), (int)0, ScreenTileEntity.class);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer playerIn) {
        if (world.field_72995_K) {
            int dz;
            int dy;
            ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.func_175625_s(pos);
            int dx = screenHitTileEntity.getDx();
            Block block = world.func_180495_p(pos.func_177982_a(dx, dy = screenHitTileEntity.getDy(), dz = screenHitTileEntity.getDz())).func_177230_c();
            if (block != ScreenSetup.screenBlock && block != ScreenSetup.creativeScreenBlock) {
                return;
            }
            RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_175625_s(pos.func_177982_a(dx, dy, dz));
            screenTileEntity.hitScreenClient(mouseOver.field_72307_f.field_72450_a - (double)pos.func_177958_n() - (double)dx, mouseOver.field_72307_f.field_72448_b - (double)pos.func_177956_o() - (double)dy, mouseOver.field_72307_f.field_72449_c - (double)pos.func_177952_p() - (double)dz, mouseOver.field_178784_b);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.activate(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if ((pos = this.getScreenBlockPos(world, pos)) == null) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        return ((ScreenBlock)block).activate(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public BlockPos getScreenBlockPos(World world, BlockPos pos) {
        int dz;
        int dy;
        ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.func_175625_s(pos);
        int dx = screenHitTileEntity.getDx();
        Block block = world.func_180495_p(pos = pos.func_177982_a(dx, dy = screenHitTileEntity.getDy(), dz = screenHitTileEntity.getDz())).func_177230_c();
        if (block != ScreenSetup.screenBlock && block != ScreenSetup.creativeScreenBlock) {
            return null;
        }
        return pos;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING);
        if (facing == EnumFacing.NORTH) {
            return NORTH_AABB;
        }
        if (facing == EnumFacing.SOUTH) {
            return SOUTH_AABB;
        }
        if (facing == EnumFacing.WEST) {
            return WEST_AABB;
        }
        if (facing == EnumFacing.EAST) {
            return EAST_AABB;
        }
        return BLOCK_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }
}

