/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import mcjty.lib.container.BaseBlock;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.shaper.GuiProjector;
import mcjty.rftools.blocks.shaper.ProjectorContainer;
import mcjty.rftools.blocks.shaper.ProjectorRenderer;
import mcjty.rftools.blocks.shaper.ProjectorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProjectorBlock
extends GenericRFToolsBlock<ProjectorTileEntity, ProjectorContainer> {
    public ProjectorBlock() {
        super(Material.field_151573_f, ProjectorTileEntity.class, ProjectorContainer.class, "projector", true);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        ClientRegistry.bindTileEntitySpecialRenderer(ProjectorTileEntity.class, (TileEntitySpecialRenderer)new ProjectorRenderer());
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.HORIZROTATION;
    }

    public boolean needsRedstoneCheck() {
        return true;
    }

    protected void checkRedstone(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof ProjectorBlock && te instanceof ProjectorTileEntity) {
            ProjectorTileEntity projector = (ProjectorTileEntity)te;
            EnumFacing horiz = OrientationTools.getOrientationHoriz((IBlockState)state);
            EnumFacing north = ProjectorBlock.reorient(EnumFacing.NORTH, horiz);
            EnumFacing south = ProjectorBlock.reorient(EnumFacing.SOUTH, horiz);
            EnumFacing west = ProjectorBlock.reorient(EnumFacing.WEST, horiz);
            EnumFacing east = ProjectorBlock.reorient(EnumFacing.EAST, horiz);
            int powered1 = this.getInputStrength(world, pos, north) > 0 ? 1 : 0;
            int powered2 = this.getInputStrength(world, pos, south) > 0 ? 2 : 0;
            int powered3 = this.getInputStrength(world, pos, west) > 0 ? 4 : 0;
            int powered4 = this.getInputStrength(world, pos, east) > 0 ? 8 : 0;
            projector.setPowerInput(powered1 + powered2 + powered3 + powered4);
        }
    }

    private static EnumFacing reorient(EnumFacing side, EnumFacing blockDirection) {
        switch (blockDirection) {
            case NORTH: {
                if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                    return side;
                }
                return side.func_176734_d();
            }
            case SOUTH: {
                return side;
            }
            case WEST: {
                if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                    return side;
                }
                if (side == EnumFacing.WEST) {
                    return EnumFacing.NORTH;
                }
                if (side == EnumFacing.NORTH) {
                    return EnumFacing.EAST;
                }
                if (side == EnumFacing.EAST) {
                    return EnumFacing.SOUTH;
                }
                return EnumFacing.WEST;
            }
            case EAST: {
                if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                    return side;
                }
                if (side == EnumFacing.WEST) {
                    return EnumFacing.SOUTH;
                }
                if (side == EnumFacing.NORTH) {
                    return EnumFacing.WEST;
                }
                if (side == EnumFacing.EAST) {
                    return EnumFacing.NORTH;
                }
                return EnumFacing.EAST;
            }
        }
        return side;
    }

    private int getInputStrength(World world, BlockPos pos, EnumFacing side) {
        IBlockState blockState;
        Block b;
        int power = world.func_175651_c(pos.func_177972_a(side), side);
        if (power == 0 && (b = (blockState = world.func_180495_p(pos.func_177972_a(side))).func_177230_c()) == Blocks.field_150488_af) {
            power = world.func_175640_z(pos.func_177972_a(side)) ? 15 : 0;
        }
        return power;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<GuiProjector> getGuiClass() {
        return GuiProjector.class;
    }

    public int getGuiID() {
        return RFTools.GUI_PROJECTOR;
    }
}

