/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.clientinfo.InfoPacketClient;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.lib.varia.BlockTools;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.blocks.storagemonitor.InventoriesInfoPacketClient;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class InventoriesInfoPacketServer
implements InfoPacketServer {
    private int id;
    private BlockPos pos;
    private boolean doscan;

    public void fromBytes(ByteBuf byteBuf) {
        this.pos = NetworkTools.readPos((ByteBuf)byteBuf);
        this.id = byteBuf.readInt();
        this.doscan = byteBuf.readBoolean();
    }

    public void toBytes(ByteBuf byteBuf) {
        NetworkTools.writePos((ByteBuf)byteBuf, (BlockPos)this.pos);
        byteBuf.writeInt(this.id);
        byteBuf.writeBoolean(this.doscan);
    }

    public InventoriesInfoPacketServer() {
    }

    public InventoriesInfoPacketServer(int worldId, BlockPos pos, boolean doscan) {
        this.id = worldId;
        this.pos = pos;
        this.doscan = doscan;
    }

    public Optional<InfoPacketClient> onMessageServer(EntityPlayerMP entityPlayerMP) {
        WorldServer world = DimensionManager.getWorld((int)this.id);
        if (world == null) {
            return Optional.empty();
        }
        if (!RFToolsTools.chunkLoaded((World)world, this.pos)) {
            return Optional.empty();
        }
        TileEntity te = world.func_175625_s(this.pos);
        if (te instanceof StorageScannerTileEntity) {
            StorageScannerTileEntity scannerTileEntity = (StorageScannerTileEntity)te;
            Stream<BlockPos> inventories = this.doscan ? scannerTileEntity.findInventories() : scannerTileEntity.getAllInventories();
            List<InventoriesInfoPacketClient.InventoryInfo> invs = inventories.map(arg_0 -> InventoriesInfoPacketServer.lambda$onMessageServer$0((World)world, scannerTileEntity, arg_0)).collect(Collectors.toList());
            return Optional.of(new InventoriesInfoPacketClient(invs));
        }
        return Optional.empty();
    }

    private static InventoriesInfoPacketClient.InventoryInfo toInventoryInfo(World world, BlockPos pos, StorageScannerTileEntity te) {
        String displayName;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!RFToolsTools.chunkLoaded(world, pos)) {
            displayName = "[UNLOADED]";
            block = null;
        } else if (world.func_175623_d(pos)) {
            displayName = "[REMOVED]";
            block = null;
        } else {
            ModularStorageTileEntity storageTileEntity;
            ItemStack storageModule;
            displayName = BlockTools.getReadableName((World)world, (BlockPos)pos);
            TileEntity storageTe = world.func_175625_s(pos);
            if (storageTe instanceof ModularStorageTileEntity && !(storageModule = (storageTileEntity = (ModularStorageTileEntity)storageTe).func_70301_a(0)).func_190926_b() && storageModule.func_77978_p().func_74764_b("display")) {
                displayName = storageModule.func_82833_r();
            }
        }
        return new InventoriesInfoPacketClient.InventoryInfo(pos, displayName, te.isRoutable(pos), block);
    }

    private static /* synthetic */ InventoriesInfoPacketClient.InventoryInfo lambda$onMessageServer$0(World world, StorageScannerTileEntity scannerTileEntity, BlockPos pos) {
        return InventoriesInfoPacketServer.toInventoryInfo(world, pos, scannerTileEntity);
    }
}

