/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.modifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.RFTools;
import mcjty.rftools.items.GenericRFToolsItem;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.modifier.ModifierCommand;
import mcjty.rftools.items.modifier.ModifierEntry;
import mcjty.rftools.items.modifier.ModifierFilterOperation;
import mcjty.rftools.items.modifier.ModifierFilterType;
import mcjty.rftools.items.modifier.ModifierInventory;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ModifierItem
extends GenericRFToolsItem {
    public ModifierItem() {
        super("modifier_module");
        this.func_77625_d(1);
    }

    private static NBTTagList getOpList(ItemStack item) {
        if (!item.func_190926_b() && item.func_77973_b() == ModItems.modifierItem) {
            NBTTagCompound tag;
            if (!item.func_77942_o()) {
                item.func_77982_d(new NBTTagCompound());
            }
            if ((tag = item.func_77978_p()).func_74764_b("ops")) {
                return tag.func_150295_c("ops", 10);
            }
            NBTTagList taglist = new NBTTagList();
            tag.func_74782_a("ops", (NBTBase)taglist);
            return taglist;
        }
        return null;
    }

    public static void performCommand(EntityPlayer player, ItemStack stack, ModifierCommand cmd, int index, ModifierFilterType type, ModifierFilterOperation op) {
        stack = stack.func_77946_l();
        switch (cmd) {
            case ADD: {
                ModifierItem.addOp(stack, type, op);
                break;
            }
            case DEL: {
                ModifierItem.delOp(stack, index);
                break;
            }
            case UP: {
                ModifierItem.upOp(stack, index);
                break;
            }
            case DOWN: {
                ModifierItem.downOp(stack, index);
            }
        }
        player.func_184611_a(EnumHand.MAIN_HAND, stack);
        player.field_71070_bA.func_75142_b();
    }

    private static NBTTagList getTagList(List<ModifierEntry> modifiers) {
        NBTTagList taglist = new NBTTagList();
        for (ModifierEntry modifier : modifiers) {
            NBTTagCompound tc;
            NBTTagCompound tag = new NBTTagCompound();
            if (!modifier.getIn().func_190926_b()) {
                tc = new NBTTagCompound();
                modifier.getIn().func_77955_b(tc);
                tag.func_74782_a("in", (NBTBase)tc);
            }
            if (!modifier.getOut().func_190926_b()) {
                tc = new NBTTagCompound();
                modifier.getOut().func_77955_b(tc);
                tag.func_74782_a("out", (NBTBase)tc);
            }
            tag.func_74778_a("type", modifier.getType().getCode());
            tag.func_74778_a("op", modifier.getOp().getCode());
            taglist.func_74742_a((NBTBase)tag);
        }
        return taglist;
    }

    private static void updateModifiers(ItemStack stack, List<ModifierEntry> modifiers) {
        NBTTagList tagList = ModifierItem.getTagList(modifiers);
        stack.func_77978_p().func_74782_a("ops", (NBTBase)tagList);
    }

    public static ItemStackList getItemStacks(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        ItemStackList stacks = ItemStackList.create((int)2);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            stacks.set(i, (Object)new ItemStack(nbtTagCompound));
        }
        return stacks;
    }

    private static void upOp(ItemStack stack, int index) {
        List<ModifierEntry> modifiers = ModifierItem.getModifiers(stack);
        ModifierEntry entry = modifiers.get(index);
        modifiers.remove(index);
        modifiers.add(index - 1, entry);
        ModifierItem.updateModifiers(stack, modifiers);
    }

    private static void downOp(ItemStack stack, int index) {
        List<ModifierEntry> modifiers = ModifierItem.getModifiers(stack);
        ModifierEntry entry = modifiers.get(index);
        modifiers.remove(index);
        modifiers.add(index + 1, entry);
        ModifierItem.updateModifiers(stack, modifiers);
    }

    private static void addOp(ItemStack stack, ModifierFilterType type, ModifierFilterOperation op) {
        List<ModifierEntry> modifiers = ModifierItem.getModifiers(stack);
        NBTTagCompound tagCompound = stack.func_77978_p();
        ItemStackList stacks = ModifierItem.getItemStacks(tagCompound);
        ItemStack stackIn = (ItemStack)stacks.get(0);
        ItemStack stackOut = (ItemStack)stacks.get(1);
        modifiers.add(new ModifierEntry(stackIn, stackOut, type, op));
        stacks.set(0, (Object)ItemStack.field_190927_a);
        stacks.set(1, (Object)ItemStack.field_190927_a);
        ModifierInventory.convertItemsToNBT(tagCompound, stacks);
        ModifierItem.updateModifiers(stack, modifiers);
    }

    private static void delOp(ItemStack stack, int index) {
        List<ModifierEntry> modifiers = ModifierItem.getModifiers(stack);
        ModifierEntry entry = modifiers.get(index);
        ItemStack in = entry.getIn();
        ItemStack out = entry.getOut();
        NBTTagCompound tagCompound = stack.func_77978_p();
        ItemStackList stacks = ModifierItem.getItemStacks(tagCompound);
        if (!in.func_190926_b() && !((ItemStack)stacks.get(0)).func_190926_b()) {
            return;
        }
        if (!out.func_190926_b() && !((ItemStack)stacks.get(1)).func_190926_b()) {
            return;
        }
        if (!in.func_190926_b()) {
            stacks.set(0, (Object)in.func_77946_l());
        }
        if (!out.func_190926_b()) {
            stacks.set(1, (Object)out.func_77946_l());
        }
        ModifierInventory.convertItemsToNBT(tagCompound, stacks);
        modifiers.remove(index);
        ModifierItem.updateModifiers(stack, modifiers);
    }

    public static List<ModifierEntry> getModifiers(ItemStack item) {
        ArrayList<ModifierEntry> modifiers = new ArrayList<ModifierEntry>();
        NBTTagList taglist = ModifierItem.getOpList(item);
        if (taglist == null) {
            return Collections.emptyList();
        }
        for (int i = 0; i < taglist.func_74745_c(); ++i) {
            NBTTagCompound compound = taglist.func_150305_b(i);
            ItemStack stackIn = new ItemStack(compound.func_74775_l("in"));
            ItemStack stackOut = new ItemStack(compound.func_74775_l("out"));
            ModifierFilterType type = ModifierFilterType.getByCode(compound.func_74779_i("type"));
            ModifierFilterOperation op = ModifierFilterOperation.getByCode(compound.func_74779_i("op"));
            modifiers.add(new ModifierEntry(stackIn, stackOut, type, op));
        }
        return modifiers;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This module can be used by the area scanner to");
            list.add(TextFormatting.WHITE + "modify the scanned output");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            player.openGui((Object)RFTools.instance, RFTools.GUI_MODIFIER_MODULE, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

