/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.screenmodules;

import java.util.List;
import mcjty.lib.varia.Logging;
import mcjty.rftools.api.screens.IModuleProvider;
import mcjty.rftools.blocks.logic.wireless.RedstoneReceiverTileEntity;
import mcjty.rftools.blocks.logic.wireless.RedstoneTransmitterTileEntity;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.RedstoneScreenModule;
import mcjty.rftools.blocks.screens.modulesclient.RedstoneClientScreenModule;
import mcjty.rftools.items.GenericRFToolsItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RedstoneModuleItem
extends GenericRFToolsItem
implements IModuleProvider {
    public RedstoneModuleItem() {
        super("redstone_module");
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("rftools:" + this.func_77658_a().substring(5), "inventory"));
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public Class<RedstoneScreenModule> getServerScreenModule() {
        return RedstoneScreenModule.class;
    }

    public Class<RedstoneClientScreenModule> getClientScreenModule() {
        return RedstoneClientScreenModule.class;
    }

    @Override
    public String getName() {
        return "Red";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        list.add(TextFormatting.GREEN + "Uses " + ScreenConfiguration.REDSTONE_RFPERTICK + " RF/tick");
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(TextFormatting.YELLOW + "Label: " + tagCompound.func_74779_i("text"));
            int channel = tagCompound.func_74762_e("channel");
            if (channel != -1) {
                list.add(TextFormatting.YELLOW + "Channel: " + channel);
            } else if (tagCompound.func_74764_b("monitorx")) {
                int mx = tagCompound.func_74762_e("monitorx");
                int my = tagCompound.func_74762_e("monitory");
                int mz = tagCompound.func_74762_e("monitorz");
                list.add(TextFormatting.YELLOW + "Block at: " + mx + "," + my + "," + mz);
            }
        }
        list.add(TextFormatting.WHITE + "Sneak right-click on a redstone transmitter or");
        list.add(TextFormatting.WHITE + "receiver to set the channel for this module.");
        list.add(TextFormatting.WHITE + "Or else sneak right-click on the side of any");
        list.add(TextFormatting.WHITE + "block to monitor the redstone output on that side");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        int channel = -1;
        if (te instanceof RedstoneReceiverTileEntity) {
            channel = ((RedstoneReceiverTileEntity)te).getChannel();
        } else if (te instanceof RedstoneTransmitterTileEntity) {
            channel = ((RedstoneTransmitterTileEntity)te).getChannel();
        } else {
            tagCompound.func_74768_a("channel", -1);
            tagCompound.func_74768_a("monitordim", world.field_73011_w.getDimension());
            tagCompound.func_74768_a("monitorx", pos.func_177958_n());
            tagCompound.func_74768_a("monitory", pos.func_177956_o());
            tagCompound.func_74768_a("monitorz", pos.func_177952_p());
            tagCompound.func_74768_a("monitorside", facing.ordinal());
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)("Redstone module is set to " + pos));
            }
            return EnumActionResult.SUCCESS;
        }
        tagCompound.func_82580_o("monitordim");
        tagCompound.func_82580_o("monitorx");
        tagCompound.func_82580_o("monitory");
        tagCompound.func_82580_o("monitorz");
        tagCompound.func_82580_o("monitorside");
        if (channel != -1) {
            tagCompound.func_74768_a("channel", channel);
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)("Redstone module is set to channel '" + channel + "'"));
            }
        } else {
            tagCompound.func_82580_o("channel");
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)"Redstone module is cleared");
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

