/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import java.util.List;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.network.Arguments;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.storage.ModularStorageItemContainer;
import mcjty.rftools.blocks.storage.ModularStorageItemInventory;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.blocks.storage.RemoteStorageIdRegistry;
import mcjty.rftools.blocks.storage.RemoteStorageItemContainer;
import mcjty.rftools.blocks.storage.RemoteStorageTileEntity;
import mcjty.rftools.blocks.storagemonitor.StorageScannerContainer;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class StorageTools {
    public static void compact(EntityPlayer player) {
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return;
        }
        NBTTagCompound tagCompound = heldItem.func_77978_p();
        if (tagCompound == null) {
            return;
        }
        if (!tagCompound.func_74764_b("childDamage")) {
            return;
        }
        int moduleDamage = tagCompound.func_74762_e("childDamage");
        if (moduleDamage == 6) {
            int id = tagCompound.func_74762_e("id");
            RemoteStorageTileEntity remoteStorage = RemoteStorageIdRegistry.getRemoteStorage(player.func_130014_f_(), id);
            if (remoteStorage != null) {
                remoteStorage.compact(id);
                remoteStorage.func_70296_d();
            } else {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Remote storage it not available (out of power or out of reach)!"));
            }
        } else {
            GenericContainer genericContainer = (GenericContainer)player.field_71070_bA;
            IInventory inventory = genericContainer.getInventory("container");
            ModularStorageItemInventory modularStorageItemInventory = (ModularStorageItemInventory)inventory;
            InventoryHelper.compactStacks((List)modularStorageItemInventory.getStacks(), (int)0, (int)inventory.func_70302_i_());
            modularStorageItemInventory.func_70296_d();
        }
    }

    public static void clearGrid(EntityPlayer player) {
        ItemStack mainhand = player.func_184614_ca();
        if (!mainhand.func_190926_b() && mainhand.func_77973_b() == ModularStorageSetup.storageModuleTabletItem) {
            if (player.field_71070_bA instanceof ModularStorageItemContainer) {
                ModularStorageItemContainer storageItemContainer = (ModularStorageItemContainer)player.field_71070_bA;
                storageItemContainer.clearGrid();
                mainhand.func_77978_p().func_82580_o("grid");
            } else if (player.field_71070_bA instanceof RemoteStorageItemContainer) {
                RemoteStorageItemContainer storageItemContainer = (RemoteStorageItemContainer)player.field_71070_bA;
                storageItemContainer.clearGrid();
                mainhand.func_77978_p().func_82580_o("grid");
            } else if (player.field_71070_bA instanceof StorageScannerContainer) {
                StorageScannerContainer storageItemContainer = (StorageScannerContainer)player.field_71070_bA;
                storageItemContainer.clearGrid();
                mainhand.func_77978_p().func_82580_o("grid");
            }
        }
    }

    public static void cycleStorage(EntityPlayer player) {
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return;
        }
        NBTTagCompound tagCompound = heldItem.func_77978_p();
        if (tagCompound == null) {
            return;
        }
        int id = tagCompound.func_74762_e("id");
        RemoteStorageTileEntity remoteStorage = RemoteStorageIdRegistry.getRemoteStorage(player.func_130014_f_(), id);
        if (remoteStorage != null) {
            id = remoteStorage.cycle(id);
            tagCompound.func_74768_a("id", id);
            int si = remoteStorage.findRemoteIndex(id);
            if (si != -1) {
                int maxStacks = remoteStorage.getMaxStacks(si);
                tagCompound.func_74768_a("maxSize", maxStacks);
            }
            remoteStorage.func_70296_d();
        } else {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Remote storage it not available (out of power or out of reach)!"));
        }
    }

    public static void returnStorageInfo(EntityPlayer player, int dimension, BlockPos pos) {
        TileEntity te;
        WorldServer world = DimensionManager.getWorld((int)dimension);
        int cnt = -1;
        String nameModule = "";
        if (world != null && (te = world.func_175625_s(pos)) instanceof ModularStorageTileEntity) {
            ModularStorageTileEntity modularStorageTileEntity = (ModularStorageTileEntity)te;
            cnt = modularStorageTileEntity.getNumStacks();
            ItemStack storageModule = modularStorageTileEntity.func_70301_a(0);
            if (!storageModule.func_190926_b() && storageModule.func_77978_p().func_74764_b("display")) {
                nameModule = storageModule.func_82833_r();
            }
        }
        RFToolsMessages.sendToClient(player, "returnStorageInfo", Arguments.builder().value(cnt).value(nameModule));
    }
}

