/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.network.AbstractServerCommand;
import mcjty.lib.network.Argument;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateNBTShapeCard
implements IMessage {
    private Map<String, Argument> args;

    public void fromBytes(ByteBuf buf) {
        this.args = AbstractServerCommand.readArguments((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        AbstractServerCommand.writeArguments((ByteBuf)buf, this.args);
    }

    public PacketUpdateNBTShapeCard() {
    }

    public PacketUpdateNBTShapeCard(Argument ... arguments) {
        if (arguments == null) {
            this.args = null;
        } else {
            this.args = new HashMap<String, Argument>(arguments.length);
            for (Argument arg : arguments) {
                this.args.put(arg.getName(), arg);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<PacketUpdateNBTShapeCard, IMessage> {
        public IMessage onMessage(PacketUpdateNBTShapeCard message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketUpdateNBTShapeCard message, MessageContext ctx) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            ItemStack heldItem = playerEntity.func_184586_b(EnumHand.MAIN_HAND);
            if (heldItem.func_190926_b()) {
                return;
            }
            NBTTagCompound tagCompound = heldItem.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
                heldItem.func_77982_d(tagCompound);
            }
            for (Map.Entry entry : message.args.entrySet()) {
                String key = (String)entry.getKey();
                switch (((Argument)entry.getValue()).getType()) {
                    case TYPE_STRING: {
                        tagCompound.func_74778_a(key, ((Argument)entry.getValue()).getString());
                        break;
                    }
                    case TYPE_INTEGER: {
                        tagCompound.func_74768_a(key, ((Argument)entry.getValue()).getInteger().intValue());
                        break;
                    }
                    case TYPE_BLOCKPOS: {
                        throw new RuntimeException("BlockPos not supported for PacketUpdateNBTItem!");
                    }
                    case TYPE_BOOLEAN: {
                        tagCompound.func_74757_a(key, ((Argument)entry.getValue()).getBoolean());
                        break;
                    }
                    case TYPE_DOUBLE: {
                        tagCompound.func_74780_a(key, ((Argument)entry.getValue()).getDouble().doubleValue());
                    }
                }
            }
        }
    }
}

