/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.shapes.Scan;
import mcjty.rftools.shapes.ScanExtraData;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;

public class ScanDataManager
extends WorldSavedData {
    public static final String SCANDATA_NETWORK_NAME = "RFToolsScanData";
    private static ScanDataManager instance = null;
    private int lastId = 0;
    private final Map<Integer, Scan> scans = new HashMap<Integer, Scan>();
    private final Map<Integer, ScanExtraData> scanData = new HashMap<Integer, ScanExtraData>();

    public ScanDataManager(String identifier) {
        super(identifier);
    }

    public void save(int scanId) {
        WorldServer world = DimensionManager.getWorld((int)0);
        File dataDir = new File(world.getChunkSaveLocation(), "rftoolsscans");
        dataDir.mkdirs();
        File file = new File(dataDir, "scan" + scanId);
        Scan scan = this.getOrCreateScan(scanId);
        NBTTagCompound tc = new NBTTagCompound();
        scan.writeToNBTExternal(tc);
        try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file));){
            CompressedStreamTools.func_74799_a((NBTTagCompound)tc, (OutputStream)dataoutputstream);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error writing to file 'scan" + scan + "'!", e);
        }
        world.func_72823_a(SCANDATA_NETWORK_NAME, (WorldSavedData)this);
        this.func_76185_a();
    }

    public static void clearInstance() {
        if (instance != null) {
            ScanDataManager.instance.scans.clear();
            instance = null;
        }
    }

    public ScanExtraData getExtraData(int id) {
        ScanExtraData data = this.scanData.get(id);
        if (data == null) {
            data = new ScanExtraData();
            this.scanData.put(id, data);
        } else if (data.getBirthTime() + (long)(ScannerConfiguration.ticksPerLocatorScan * 100) < System.currentTimeMillis()) {
            data = new ScanExtraData();
            this.scanData.put(id, data);
        }
        return data;
    }

    public static ScanDataManager getScans() {
        WorldServer world = DimensionManager.getWorld((int)0);
        if (instance != null) {
            return instance;
        }
        instance = (ScanDataManager)world.func_72943_a(ScanDataManager.class, SCANDATA_NETWORK_NAME);
        if (instance == null) {
            instance = new ScanDataManager(SCANDATA_NETWORK_NAME);
        }
        return instance;
    }

    @Nonnull
    public Scan getOrCreateScan(int id) {
        Scan scan = this.scans.get(id);
        if (scan == null) {
            scan = new Scan();
            this.scans.put(id, scan);
        }
        return scan;
    }

    @Nonnull
    public Scan loadScan(int id) {
        WorldServer world = DimensionManager.getWorld((int)0);
        Scan scan = this.scans.get(id);
        if (scan == null || scan.getDataInt() == null) {
            if (scan == null) {
                scan = new Scan();
            }
            File dataDir = new File(world.getChunkSaveLocation(), "rftoolsscans");
            dataDir.mkdirs();
            File file = new File(dataDir, "scan" + id);
            if (file.exists()) {
                try (DataInputStream datainputstream = new DataInputStream(new FileInputStream(file));){
                    NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)datainputstream);
                    scan.readFromNBTExternal(tag);
                }
                catch (IOException e) {
                    Logging.log((String)("Error reading scan file for id: " + id));
                }
            }
        }
        return scan;
    }

    public static void listScans(ICommandSender sender) {
        ScanDataManager scans = ScanDataManager.getScans();
        for (Map.Entry<Integer, Scan> entry : scans.scans.entrySet()) {
            Integer scanid = entry.getKey();
            scans.loadScan(scanid);
            Scan scan = entry.getValue();
            BlockPos dim = scan.getDataDim();
            if (dim == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Scan: " + TextFormatting.WHITE + scanid + TextFormatting.RED + "   Invalid"));
                continue;
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Scan: " + TextFormatting.WHITE + scanid + TextFormatting.YELLOW + "   Dim: " + TextFormatting.WHITE + dim.func_177958_n() + "," + dim.func_177956_o() + "," + dim.func_177952_p() + TextFormatting.YELLOW + "   Size: " + TextFormatting.WHITE + scan.getRledata().length + " bytes"));
        }
    }

    public int newScan(World world) {
        ++this.lastId;
        world.func_72823_a(SCANDATA_NETWORK_NAME, (WorldSavedData)this);
        this.func_76185_a();
        return this.lastId;
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.scans.clear();
        NBTTagList lst = tagCompound.func_150295_c("scans", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            int id = tc.func_74762_e("scan");
            Scan scan = new Scan();
            scan.readFromNBT(tc);
            this.scans.put(id, scan);
        }
        this.lastId = tagCompound.func_74762_e("lastId");
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<Integer, Scan> entry : this.scans.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74768_a("scan", entry.getKey().intValue());
            entry.getValue().writeToNBT(tc);
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("scans", (NBTBase)lst);
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }
}

