/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.rftools.shapes.Formulas;
import mcjty.rftools.shapes.IFormulaFactory;

public enum Shape {
    SHAPE_BOX("Box", Formulas.FORMULA_BOX),
    SHAPE_TOPDOME("Top Dome", Formulas.FORMULA_TOPDOME),
    SHAPE_BOTTOMDOME("Bottom Dome", Formulas.FORMULA_BOTTOMDOME),
    SHAPE_SPHERE("Sphere", Formulas.FORMULA_SPHERE),
    SHAPE_CYLINDER("Cylinder", Formulas.FORMULA_CYLINDER),
    SHAPE_CAPPEDCYLINDER("Capped Cylinder", Formulas.FORMULA_CAPPED_CYLINDER),
    SHAPE_PRISM("Prism", Formulas.FORMULA_PRISM),
    SHAPE_TORUS("Torus", Formulas.FORMULA_TORUS),
    SHAPE_HEART("Heart", Formulas.FORMULA_HEART),
    SHAPE_CONE("Cone", Formulas.FORMULA_CONE),
    SHAPE_COMPOSITION("Composition", Formulas.FORMULA_COMPOSITION),
    SHAPE_SCAN("Scan", Formulas.FORMULA_SCAN);

    private final String description;
    private final IFormulaFactory formulaFactory;
    private static final Map<String, Shape> SHAPES_BY_DESCRIPTION;

    private Shape(String description, IFormulaFactory formulaFactory) {
        this.description = description;
        this.formulaFactory = formulaFactory;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isComposition() {
        return this == SHAPE_COMPOSITION;
    }

    public boolean isScan() {
        return this == SHAPE_SCAN;
    }

    @Nonnull
    public IFormulaFactory getFormulaFactory() {
        return this.formulaFactory;
    }

    public static Shape getShape(String description) {
        return SHAPES_BY_DESCRIPTION.get(description);
    }

    static {
        SHAPES_BY_DESCRIPTION = new HashMap<String, Shape>();
        for (Shape shape : Shape.values()) {
            SHAPES_BY_DESCRIPTION.put(shape.getDescription(), shape);
        }
    }
}

