/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.varia;

import java.util.HashMap;
import mcjty.lib.api.information.IMachineInformation;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftools.network.MachineInfo;
import mcjty.rftools.network.PacketReturnRfInRange;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RFToolsTools {
    public static boolean chunkLoaded(World world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        return world.func_175667_e(pos);
    }

    public static boolean hasModuleTarget(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74764_b("monitorx");
    }

    public static int getDimensionFromModule(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("monitordim");
    }

    public static void setPositionInModule(ItemStack stack, Integer dimension, BlockPos pos, String name) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (dimension != null) {
            stack.func_77978_p().func_74768_a("monitordim", dimension.intValue());
        }
        if (name != null) {
            stack.func_77978_p().func_74778_a("monitorname", name);
        }
        stack.func_77978_p().func_74768_a("monitorx", pos.func_177958_n());
        stack.func_77978_p().func_74768_a("monitory", pos.func_177956_o());
        stack.func_77978_p().func_74768_a("monitorz", pos.func_177952_p());
    }

    public static void clearPositionInModule(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        tagCompound.func_82580_o("monitordim");
        tagCompound.func_82580_o("monitorx");
        tagCompound.func_82580_o("monitory");
        tagCompound.func_82580_o("monitorz");
        tagCompound.func_82580_o("monitorname");
    }

    public static BlockPos getPositionFromModule(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        int monitorx = tagCompound.func_74762_e("monitorx");
        int monitory = tagCompound.func_74762_e("monitory");
        int monitorz = tagCompound.func_74762_e("monitorz");
        return new BlockPos(monitorx, monitory, monitorz);
    }

    public static void returnRfInRange(EntityPlayer player) {
        BlockPos pos = player.func_180425_c();
        World world = player.func_130014_f_();
        HashMap<BlockPos, MachineInfo> result = new HashMap<BlockPos, MachineInfo>();
        int range = 12;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos p = pos.func_177982_a(x, y, z);
                    TileEntity te = world.func_175625_s(p);
                    if (!EnergyTools.isEnergyTE((TileEntity)te)) continue;
                    EnergyTools.EnergyLevel level = EnergyTools.getEnergyLevel((TileEntity)te);
                    Integer usage = null;
                    if (te instanceof IMachineInformation) {
                        usage = ((IMachineInformation)te).getEnergyDiffPerTick();
                    }
                    result.put(p, new MachineInfo(level.getEnergy(), level.getMaxEnergy(), usage));
                }
            }
        }
        RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketReturnRfInRange(result), (EntityPlayerMP)player);
    }
}

