/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockDetection;
import slimeknights.tconstruct.smeltery.tileentity.TileMultiblock;

public abstract class TileHeatingStructure<T extends MultiblockDetection>
extends TileMultiblock<T> {
    public static final String TAG_FUEL = "fuel";
    public static final String TAG_TEMPERATURE = "temperature";
    public static final String TAG_NEEDS_FUEL = "needsFuel";
    public static final String TAG_ITEM_TEMPERATURES = "itemTemperatures";
    public static final String TAG_ITEM_TEMP_REQUIRED = "itemTempRequired";
    protected static final int TIME_FACTOR = 8;
    protected int fuel;
    protected int temperature;
    protected boolean needsFuel;
    protected int[] itemTemperatures = new int[0];
    protected int[] itemTempRequired = new int[0];

    public TileHeatingStructure(String name, int inventorySize, int maxStackSize) {
        super(name, inventorySize, maxStackSize);
    }

    public void resize(int size) {
        super.resize(size);
        this.itemTemperatures = Arrays.copyOf(this.itemTemperatures, size);
        this.itemTempRequired = Arrays.copyOf(this.itemTempRequired, size);
    }

    public boolean canHeat(int index) {
        return this.temperature >= this.getHeatRequiredForSlot(index);
    }

    public float getProgress(int index) {
        if (index >= this.itemTemperatures.length) {
            return 0.0f;
        }
        return (float)this.itemTemperatures[index] / (float)this.itemTempRequired[index];
    }

    protected void setHeatRequiredForSlot(int index, int heat) {
        if (index < this.itemTempRequired.length) {
            this.itemTempRequired[index] = heat * 8;
        }
    }

    protected int getHeatRequiredForSlot(int index) {
        if (index >= this.itemTempRequired.length) {
            return 0;
        }
        return this.itemTempRequired[index] / 8;
    }

    protected abstract void updateHeatRequired(int var1);

    protected void heatItems() {
        boolean heatedItem = false;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (!stack.func_190926_b()) {
                if (this.itemTempRequired[i] <= 0 || !this.canHeat(i)) continue;
                if (this.hasFuel()) {
                    if (this.itemTemperatures[i] >= this.itemTempRequired[i]) {
                        if (!this.onItemFinishedHeating(stack, i)) continue;
                        this.itemTemperatures[i] = 0;
                        this.itemTempRequired[i] = 0;
                        continue;
                    }
                    int n = i;
                    this.itemTemperatures[n] = this.itemTemperatures[n] + this.heatSlot(i);
                    heatedItem = true;
                    continue;
                }
                this.needsFuel = true;
                return;
            }
            this.itemTemperatures[i] = 0;
        }
        if (heatedItem) {
            --this.fuel;
        }
    }

    protected int heatSlot(int i) {
        return this.temperature / 100;
    }

    public int getTemperature(int i) {
        if (i < 0 || i >= this.itemTemperatures.length) {
            return 0;
        }
        return this.itemTemperatures[i];
    }

    public int getTempRequired(int i) {
        if (i < 0 || i >= this.itemTempRequired.length) {
            return 0;
        }
        return this.itemTempRequired[i];
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        if (itemstack.func_190926_b() || !this.func_70301_a(slot).func_190926_b() && !ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)this.func_70301_a(slot))) {
            this.itemTemperatures[slot] = 0;
        }
        super.func_70299_a(slot, itemstack);
        this.updateHeatRequired(slot);
    }

    protected abstract boolean onItemFinishedHeating(ItemStack var1, int var2);

    protected abstract void consumeFuel();

    protected void addFuel(int fuel, int newTemperature) {
        this.fuel += fuel;
        this.needsFuel = false;
        this.temperature = newTemperature;
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    public int getFuel() {
        return this.fuel;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTemperatureFromPacket(int index, int heat) {
        if (index < 0 || index > this.func_70302_i_() - 1) {
            return;
        }
        this.itemTemperatures[index] = heat;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTempRequiredFromPacket(int index, int heat) {
        if (index < 0 || index > this.func_70302_i_() - 1) {
            return;
        }
        this.itemTempRequired[index] = heat;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTemperatureFromPacket(int temperature) {
        this.temperature = temperature;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags = super.func_189515_b(tags);
        tags.func_74768_a(TAG_FUEL, this.fuel);
        tags.func_74768_a(TAG_TEMPERATURE, this.temperature);
        tags.func_74757_a(TAG_NEEDS_FUEL, this.needsFuel);
        tags.func_74783_a(TAG_ITEM_TEMPERATURES, this.itemTemperatures);
        tags.func_74783_a(TAG_ITEM_TEMP_REQUIRED, this.itemTempRequired);
        return tags;
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.fuel = tags.func_74762_e(TAG_FUEL);
        this.temperature = tags.func_74762_e(TAG_TEMPERATURE);
        this.needsFuel = tags.func_74767_n(TAG_NEEDS_FUEL);
        this.itemTemperatures = tags.func_74759_k(TAG_ITEM_TEMPERATURES);
        this.itemTempRequired = tags.func_74759_k(TAG_ITEM_TEMP_REQUIRED);
    }
}

