/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item.util;

import cofh.api.item.IMultiModeItem;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.core.IQuiverItem;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstonearsenal.RedstoneArsenal;
import cofh.redstonearsenal.entity.projectile.EntityFluxArrow;
import cofh.redstonearsenal.init.RAProps;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.util.EnergyContainerItemWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemQuiverFlux
extends ItemCore
implements IModelRegister,
IMultiModeItem,
IEnergyContainerItem,
IQuiverItem,
IEnchantableItem,
IInitializer {
    protected int maxEnergy = 320000;
    protected int maxTransfer = 4000;
    protected int energyPerUse = 800;
    protected int energyPerUseCharged = 6400;
    protected boolean showInCreative = true;
    public static boolean enable;
    public static ItemStack quiverElectrumFlux;

    public ItemQuiverFlux() {
        super("redstonearsenal");
        this.setNoRepair();
        this.func_77625_d(1);
        this.func_77655_b("redstonearsenal.util.fluxQuiver");
        this.func_77637_a(RedstoneArsenal.tabCommon);
        this.func_185043_a(new ResourceLocation("active"), (stack, world, entity) -> this.getEnergyStored(stack) > 0 && !this.isEmpowered(stack) ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("empowered"), (stack, world, entity) -> this.isEmpowered(stack) ? 1.0f : 0.0f);
    }

    public ItemQuiverFlux setEnergyParams(int maxEnergy, int maxTransfer, int energyPerUse, int energyPerUseCharged) {
        this.maxEnergy = maxEnergy;
        this.maxTransfer = maxTransfer;
        this.energyPerUse = energyPerUse;
        this.energyPerUseCharged = energyPerUseCharged;
        return this;
    }

    protected boolean isEmpowered(ItemStack stack) {
        return this.getMode(stack) == 1 && this.getEnergyStored(stack) >= this.energyPerUseCharged;
    }

    protected int getEnergyPerUse(ItemStack stack) {
        int unbreakingLevel = MathHelper.clamp((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack), (int)0, (int)4);
        return (this.isEmpowered(stack) ? this.energyPerUseCharged : this.energyPerUse) * (5 - unbreakingLevel) / 5;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.formatNumber((long)stack.func_77978_p().func_74762_e("Energy")) + " / " + StringHelper.formatNumber((long)this.getMaxEnergyStored(stack)) + " RF");
        tooltip.add("\u00a76" + this.getEnergyPerUse(stack) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.energyPerUse") + "\u00a7r");
        RAProps.addEmpoweredTip(this, stack, tooltip);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab) && this.showInCreative) {
            items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, 0), (int)0));
            items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, 0), (int)this.maxEnergy));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (stack.func_77952_i() > 0) {
            stack.func_77964_b(0);
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return RAProps.showToolCharge && stack.func_77978_p() != null && !stack.func_77978_p().func_74767_n("CreativeTab");
    }

    public int getItemEnchantability(ItemStack stack) {
        return 10;
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xD01010;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.getMaxEnergyStored(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.isEmpowered(stack) ? EnumRarity.RARE : EnumRarity.UNCOMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("redstonearsenal:util/quiver_flux", "inventory"));
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        if (this.isEmpowered(stack)) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187754_de, SoundCategory.PLAYERS, 0.4f, 1.0f);
        } else {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.6f);
        }
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(this.getMaxEnergyStored(container) - stored, this.maxTransfer));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        if (container.func_77978_p().func_74764_b("Unbreakable")) {
            container.func_77978_p().func_82580_o("Unbreakable");
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored -= extract);
            if (stored == 0) {
                this.setMode(container, 0);
            }
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)container);
        return this.maxEnergy + this.maxEnergy * enchant / 2;
    }

    public EntityArrow createEntityArrow(World world, ItemStack stack, EntityLivingBase shooter) {
        return new EntityFluxArrow(world, shooter, this.isEmpowered(stack));
    }

    public boolean isEmpty(ItemStack stack, EntityLivingBase shooter) {
        return (!(shooter instanceof EntityPlayer) || !((EntityPlayer)shooter).field_71075_bZ.field_75098_d) && this.getEnergyStored(stack) <= 0;
    }

    public void onArrowFired(ItemStack stack, EntityLivingBase shooter) {
        if (shooter instanceof EntityPlayer) {
            this.extractEnergy(stack, this.getEnergyPerUse(stack), ((EntityPlayer)shooter).field_71075_bZ.field_75098_d);
        }
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this);
    }

    public boolean initialize() {
        this.setRegistryName("util.quiver_flux");
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
        ItemQuiverFlux.config();
        this.showInCreative = enable;
        quiverElectrumFlux = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, 0), (int)0);
        RedstoneArsenal.proxy.addIModelRegister(this);
        return true;
    }

    public boolean register() {
        if (!enable) {
            return false;
        }
        RecipeHelper.addShapedRecipe((ItemStack)quiverElectrumFlux, (Object[])new Object[]{"AA ", "GIS", "IGS", Character.valueOf('A'), Items.field_151032_g, Character.valueOf('G'), "gemCrystalFlux", Character.valueOf('I'), "ingotElectrumFlux", Character.valueOf('S'), Items.field_151007_F});
        return true;
    }

    private static void config() {
        String category = "Equipment.Tools.Flux";
        enable = RedstoneArsenal.CONFIG.get(category, "Quiver", true);
    }
}

