/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import wanion.lib.common.Util;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.resource.UniResourceContainer;

final class FurnaceIntegration
extends AbstractIntegrationThread {
    private final Map<ItemStack, Float> experienceMap = (Map)Util.getField(FurnaceRecipes.class, (String)"experienceList", (String)"field_77605_c", (Object)FurnaceRecipes.func_77602_a(), Map.class);

    FurnaceIntegration() {
        super("Furnace");
    }

    public String call() {
        try {
            this.optimizeFurnaceRecipes();
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
        }
        return this.threadName + "Some things that you smelted appear to be different now.";
    }

    private void optimizeFurnaceRecipes() {
        if (!this.config.inputReplacementFurnace) {
            for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
                ItemStack oldEntry = (ItemStack)entry.getValue();
                ItemStack newEntry = this.resourceHandler.getMainItemStack(oldEntry);
                entry.setValue(newEntry);
                if (!this.experienceMap.containsKey(oldEntry)) continue;
                this.experienceMap.put(newEntry, this.experienceMap.remove(oldEntry));
            }
        } else {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerKindMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Map map = FurnaceRecipes.func_77602_a().func_77599_b();
            HashMap<ItemStack, ItemStack> newRecipes = new HashMap<ItemStack, ItemStack>();
            Iterator furnaceRecipeIterator = map.entrySet().iterator();
            while (furnaceRecipeIterator.hasNext()) {
                TIntSet kindSet;
                Map.Entry furnaceRecipe = furnaceRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer((ItemStack)furnaceRecipe.getKey());
                UniResourceContainer outputContainer = this.resourceHandler.getContainer((ItemStack)furnaceRecipe.getValue());
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    furnaceRecipe.setValue(outputContainer.getMainEntry(((ItemStack)furnaceRecipe.getValue()).func_190916_E()));
                    continue;
                }
                int kind = inputContainer.kind;
                ItemStack oldEntry = (ItemStack)furnaceRecipe.getValue();
                if (!containerKindMap.containsKey(outputContainer)) {
                    containerKindMap.put(outputContainer, new TIntHashSet());
                }
                if (!(kindSet = (TIntSet)containerKindMap.get(outputContainer)).contains(kind)) {
                    kindSet.add(kind);
                    ItemStack newEntry = outputContainer.getMainEntry(oldEntry.func_190916_E());
                    newRecipes.put(inputContainer.getMainEntry(((ItemStack)furnaceRecipe.getKey()).func_190916_E()), newEntry);
                    if (this.experienceMap.containsKey(oldEntry)) {
                        this.experienceMap.put(newEntry, this.experienceMap.remove(oldEntry));
                    }
                }
                furnaceRecipeIterator.remove();
                this.experienceMap.remove(oldEntry);
            }
            map.putAll(newRecipes);
        }
    }
}

